% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers.R
\name{.number}
\alias{.number}
\title{Number Legnth}
\description{
Number Legnth

Number Legnth
}
\details{
R6 class representing a \code{number}

Object of this class are created by the '.modello'
session object that linkes them with the corresponding
\code{numbers} in the FORTRAN environment.
}
\examples{

## ------------------------------------------------
## Method `.number$pop`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$is.linked() # TRUE
x$pop()
x$is.linked() # FALSE
modello.close()
}

## ------------------------------------------------
## Method `.number$is.linked`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$is.linked() # TRUE
x$pop()
x$is.linked() # FALSE
modello.close()
}

## ------------------------------------------------
## Method `.number$rank`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9), 3, 3))
x$rank() # 2
modello.close()
}

## ------------------------------------------------
## Method `.number$has.dx`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x1 = number(1)
x1$has.dx() # TRUE
x2 = number(1, dx=FALSE)
x2$has.dx() # FALSE
modello.close()
}

## ------------------------------------------------
## Method `.number$length`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(c(1, 2, 3))
x$length() # 3
modello.close()
}

## ------------------------------------------------
## Method `.number$dim`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9, 3, 3)))
x$dim() # c(3, 3)
modello.close()
}

## ------------------------------------------------
## Method `.number$set.v`
## ------------------------------------------------

modello.init(10, 10, 10, 10)
x = number(1)
x$set.v(2)
x$get.v()
modello.close()

## ------------------------------------------------
## Method `.number$get.v`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$set.v(2)
x$get.v()
modello.close()
}

## ------------------------------------------------
## Method `.number$set.dv`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$set.dv(1)
x$get.dv()
modello.close()
}

## ------------------------------------------------
## Method `.number$set.slice`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(0, 3, 3))
print(x$v)
print(x$dv)
x$set.slice(1, 1:3, 1:3)
x$set.slice(2, 1:3, 1:3, dx=TRUE)
print(x$v)
print(x$dv)
modello.close()
}

## ------------------------------------------------
## Method `.number$set.flat_slice`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(0, 3, 3))
print(x$v)
print(x$dv)
x$set.flat_slice(1, 1:9)
x$set.flat_slice(2, 1:9, dx=TRUE)
print(x$v)
print(x$dv)
modello.close()
}

## ------------------------------------------------
## Method `.number$get.dv`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$set.dv(1)
x$get.dv()
modello.close()
}

## ------------------------------------------------
## Method `.number$slice`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9), 3, 3))
print(x$v)
y = x$slice(1:2, 1:3)
print(y$v)
modello.close()
}

## ------------------------------------------------
## Method `.number$flat_slice`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9), 3, 3))
print(x$v)
y = x$flat_slice(1:6)
print(y$v)
modello.close()
}

## ------------------------------------------------
## Method `.number$contiguous.slice`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9), 3, 3))
print(x$v)
y = x$slice(1, 2)
print(y$v)
modello.close()
}

## ------------------------------------------------
## Method `.number$reshape`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(c(1, 2, 3, 4, 5, 6))
y = x$reshape(c(3, 2))
print(x)
print(x$v)
print(y)
print(y$v)
modello.close()
}

## ------------------------------------------------
## Method `.number$drop.dim`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(as.matrix(c(1, 2, 3)))
print(x)
print(x$v)
y = x$drop.dim()
print(y)
print(y$v)
modello.close()
}

## ------------------------------------------------
## Method `.number$bind`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x = number(as.matrix(c(1, 2, 3)))
y = number(as.matrix(c(4, 5, 6)))
z = x$bind(y, 2)
print(z)
print(z$v)
modello.close()
}

## ------------------------------------------------
## Method `.number$op`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
g = graph.open()
x1 = number(1)
x2 = number(2)
x3 = x1 + x2
graph.close()
print(x3$v)
x1$v = 2
x3$op()
print(x3$v)
modello.close()
}

## ------------------------------------------------
## Method `.number$bw.zero`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
g = graph.open()
x1 = number(4)
x2 = number(2)
x3 = x1 ** x2
g = graph.close()
print(x1$dv)
print(x2$dv)
x3$dv = 1
x3$bw()
print(x1$dv)
print(x2$dv)
x3$bw.zero()
print(x1$dv)
print(x2$dv)
modello.close()
}

## ------------------------------------------------
## Method `.number$bw`
## ------------------------------------------------

\donttest{
modello.init(10, 10, 10, 10)
x1 = number(4)
x2 = number(2)
g = graph.open()
x3 = x1 ** x2
graph.close()
print(x1$dv)
print(x2$dv)
x3$dv = 1
x3$bw()
print(x1$dv)
print(x2$dv)
x3$bw.zero()
print(x1$dv)
print(x2$dv)
modello.close()
}
}
\author{
Filippo Monari

Filippo Monari
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{v}}{Sets or gets the \code{number} value}

\item{\code{dv}}{Sets or gets the \code{number} derivative value}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{.number$new()}}
\item \href{#method-finalize}{\code{.number$finalize()}}
\item \href{#method-name}{\code{.number$name()}}
\item \href{#method-id}{\code{.number$id()}}
\item \href{#method-pop}{\code{.number$pop()}}
\item \href{#method-is.linked}{\code{.number$is.linked()}}
\item \href{#method-rank}{\code{.number$rank()}}
\item \href{#method-has.dx}{\code{.number$has.dx()}}
\item \href{#method-collect}{\code{.number$collect()}}
\item \href{#method-save}{\code{.number$save()}}
\item \href{#method-length}{\code{.number$length()}}
\item \href{#method-dim}{\code{.number$dim()}}
\item \href{#method-set.v}{\code{.number$set.v()}}
\item \href{#method-get.v}{\code{.number$get.v()}}
\item \href{#method-set.dv}{\code{.number$set.dv()}}
\item \href{#method-set.slice}{\code{.number$set.slice()}}
\item \href{#method-set.flat_slice}{\code{.number$set.flat_slice()}}
\item \href{#method-get.dv}{\code{.number$get.dv()}}
\item \href{#method-slice}{\code{.number$slice()}}
\item \href{#method-flat_slice}{\code{.number$flat_slice()}}
\item \href{#method-contiguous.slice}{\code{.number$contiguous.slice()}}
\item \href{#method-reshape}{\code{.number$reshape()}}
\item \href{#method-drop.dim}{\code{.number$drop.dim()}}
\item \href{#method-bind}{\code{.number$bind()}}
\item \href{#method-op}{\code{.number$op()}}
\item \href{#method-bw.zero}{\code{.number$bw.zero()}}
\item \href{#method-bw}{\code{.number$bw()}}
\item \href{#method-print}{\code{.number$print()}}
\item \href{#method-clone}{\code{.number$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialise the reference object of class 'number'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$new(name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{number} name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Awares of a reference object associated
to an existing \code{number} is removed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-name"></a>}}
\if{latex}{\out{\hypertarget{method-name}{}}}
\subsection{Method \code{name()}}{
Returns the name of the \code{number}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the name of the \code{number}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-id"></a>}}
\if{latex}{\out{\hypertarget{method-id}{}}}
\subsection{Method \code{id()}}{
Returns the id of the \code{number}
(i.e. its position index in the \code{NUMBERS_} array).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$id()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the id of the number
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pop"></a>}}
\if{latex}{\out{\hypertarget{method-pop}{}}}
\subsection{Method \code{pop()}}{
Pop (removes) the \code{number} from the
\code{NUMBERS_} array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$pop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$is.linked() # TRUE
x$pop()
x$is.linked() # FALSE
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is.linked"></a>}}
\if{latex}{\out{\hypertarget{method-is.linked}{}}}
\subsection{Method \code{is.linked()}}{
Checks that the reference object is linked to
a \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$is.linked()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Retursn TRUE if is linked, FALSE otherwise
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$is.linked() # TRUE
x$pop()
x$is.linked() # FALSE
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rank"></a>}}
\if{latex}{\out{\hypertarget{method-rank}{}}}
\subsection{Method \code{rank()}}{
Returns the rank of the \code{number}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$rank()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the rank of the \code{number}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9), 3, 3))
x$rank() # 2
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has.dx"></a>}}
\if{latex}{\out{\hypertarget{method-has.dx}{}}}
\subsection{Method \code{has.dx()}}{
Returns TRUE if the \code{number} has derivative,
FALSE otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$has.dx()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE/FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x1 = number(1)
x1$has.dx() # TRUE
x2 = number(1, dx=FALSE)
x2$has.dx() # FALSE
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collect"></a>}}
\if{latex}{\out{\hypertarget{method-collect}{}}}
\subsection{Method \code{collect()}}{
Returns a list representation of the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$collect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\if{latex}{\out{\hypertarget{method-save}{}}}
\subsection{Method \code{save()}}{
Saves the \code{number} in RDS format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$save(file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{filename, if null the \code{number} name is used}

\item{\code{...}}{additional arguments for the function \code{saveRDS}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-length"></a>}}
\if{latex}{\out{\hypertarget{method-length}{}}}
\subsection{Method \code{length()}}{
Returns the size of the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the size of the \code{number}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(c(1, 2, 3))
x$length() # 3
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dim"></a>}}
\if{latex}{\out{\hypertarget{method-dim}{}}}
\subsection{Method \code{dim()}}{
Returns the shape of the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$dim()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the \code{number} shape
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9, 3, 3)))
x$dim() # c(3, 3)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set.v"></a>}}
\if{latex}{\out{\hypertarget{method-set.v}{}}}
\subsection{Method \code{set.v()}}{
Sets the value of the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$set.v(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{number} value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{modello.init(10, 10, 10, 10)
x = number(1)
x$set.v(2)
x$get.v()
modello.close()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get.v"></a>}}
\if{latex}{\out{\hypertarget{method-get.v}{}}}
\subsection{Method \code{get.v()}}{
Returns the value of a \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$get.v()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the \code{number} value
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$set.v(2)
x$get.v()
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set.dv"></a>}}
\if{latex}{\out{\hypertarget{method-set.dv}{}}}
\subsection{Method \code{set.dv()}}{
Sets the derivative value of the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$set.dv(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{number} derivative value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$set.dv(1)
x$get.dv()
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set.slice"></a>}}
\if{latex}{\out{\hypertarget{method-set.slice}{}}}
\subsection{Method \code{set.slice()}}{
Sets the values of a slice in a \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$set.slice(v, ..., dx = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{value to be set}

\item{\code{...}}{indexes along the number dimensions defining the slice}

\item{\code{dx}}{if TRUE the slice is taken from the gradient}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(0, 3, 3))
print(x$v)
print(x$dv)
x$set.slice(1, 1:3, 1:3)
x$set.slice(2, 1:3, 1:3, dx=TRUE)
print(x$v)
print(x$dv)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set.flat_slice"></a>}}
\if{latex}{\out{\hypertarget{method-set.flat_slice}{}}}
\subsection{Method \code{set.flat_slice()}}{
Sets the values of a slice in a \code{number}
considering the number flat
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$set.flat_slice(v, s, dx = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{value to be set}

\item{\code{s}}{indexes defining the slice}

\item{\code{dx}}{if TRUE the slice is taken from the gradient}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(0, 3, 3))
print(x$v)
print(x$dv)
x$set.flat_slice(1, 1:9)
x$set.flat_slice(2, 1:9, dx=TRUE)
print(x$v)
print(x$dv)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get.dv"></a>}}
\if{latex}{\out{\hypertarget{method-get.dv}{}}}
\subsection{Method \code{get.dv()}}{
Returns the derivative value of a \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$get.dv()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the \code{number} value
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(1)
x$set.dv(1)
x$get.dv()
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slice"></a>}}
\if{latex}{\out{\hypertarget{method-slice}{}}}
\subsection{Method \code{slice()}}{
Create a slice of the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$slice(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{slice indexes}

\item{\code{name}}{outout \code{number} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number' with the slice
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9), 3, 3))
print(x$v)
y = x$slice(1:2, 1:3)
print(y$v)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-flat_slice"></a>}}
\if{latex}{\out{\hypertarget{method-flat_slice}{}}}
\subsection{Method \code{flat_slice()}}{
Create a flat slice of the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$flat_slice(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{flat slice indexes}

\item{\code{name}}{outout \code{number} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number' with the flat slice
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9), 3, 3))
print(x$v)
y = x$flat_slice(1:6)
print(y$v)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-contiguous.slice"></a>}}
\if{latex}{\out{\hypertarget{method-contiguous.slice}{}}}
\subsection{Method \code{contiguous.slice()}}{
Create a contiguous slice of the \code{number}.
Slice along the leading order (columns). 

The \code{number} values are not copied but only referred through pointers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$contiguous.slice(s1, s2 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s1}}{intial index of the contiguous slice}

\item{\code{s2}}{final index of the contiguous slice}

\item{\code{name}}{outout \code{number} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number' with the contiguous slice
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(matrix(rnorm(9), 3, 3))
print(x$v)
y = x$slice(1, 2)
print(y$v)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reshape"></a>}}
\if{latex}{\out{\hypertarget{method-reshape}{}}}
\subsection{Method \code{reshape()}}{
Reshape the \code{number} according the the given shape vector.

The \code{number} is not copied but reshaped through pointers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$reshape(shp, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shp}}{shape vector}

\item{\code{name}}{output \code{number} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number' with the reshape
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(c(1, 2, 3, 4, 5, 6))
y = x$reshape(c(3, 2))
print(x)
print(x$v)
print(y)
print(y$v)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-drop.dim"></a>}}
\if{latex}{\out{\hypertarget{method-drop.dim}{}}}
\subsection{Method \code{drop.dim()}}{
Reshape the \code{number} by dropping the collapsed dimensions.

The \code{number} is not copied but reshaped through pointers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$drop.dim()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{output \code{number} name}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(as.matrix(c(1, 2, 3)))
print(x)
print(x$v)
y = x$drop.dim()
print(y)
print(y$v)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bind"></a>}}
\if{latex}{\out{\hypertarget{method-bind}{}}}
\subsection{Method \code{bind()}}{
Binds the \code{number} to another along the given dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$bind(x, k)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{number} to bind}

\item{\code{k}}{dimension index}

\item{\code{name}}{name of the output \code{number}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns areference object of class 'number'
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x = number(as.matrix(c(1, 2, 3)))
y = number(as.matrix(c(4, 5, 6)))
z = x$bind(y, 2)
print(z)
print(z$v)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-op"></a>}}
\if{latex}{\out{\hypertarget{method-op}{}}}
\subsection{Method \code{op()}}{
Runs the node operator that generated the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$op()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
g = graph.open()
x1 = number(1)
x2 = number(2)
x3 = x1 + x2
graph.close()
print(x3$v)
x1$v = 2
x3$op()
print(x3$v)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bw.zero"></a>}}
\if{latex}{\out{\hypertarget{method-bw.zero}{}}}
\subsection{Method \code{bw.zero()}}{
Resest the derivative values for the \code{number} node
accoriding to the backward differentiation schema.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$bw.zero()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
g = graph.open()
x1 = number(4)
x2 = number(2)
x3 = x1 ** x2
g = graph.close()
print(x1$dv)
print(x2$dv)
x3$dv = 1
x3$bw()
print(x1$dv)
print(x2$dv)
x3$bw.zero()
print(x1$dv)
print(x2$dv)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bw"></a>}}
\if{latex}{\out{\hypertarget{method-bw}{}}}
\subsection{Method \code{bw()}}{
Applies bakward differentiation to the \code{number} node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$bw()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init(10, 10, 10, 10)
x1 = number(4)
x2 = number(2)
g = graph.open()
x3 = x1 ** x2
graph.close()
print(x1$dv)
print(x2$dv)
x3$dv = 1
x3$bw()
print(x1$dv)
print(x2$dv)
x3$bw.zero()
print(x1$dv)
print(x2$dv)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints a representation of the \code{number}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.number$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
