% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.model_set.R
\name{print.model_set}
\alias{print.model_set}
\title{Print a \code{model_set}-Class Object}
\usage{
\method{print}{model_set}(
  x,
  bic_digits = 3,
  bpp_digits = 3,
  sort_models = TRUE,
  max_models = 20,
  bpp_target = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{model_set}-class object.}

\item{bic_digits}{The number of
decimal places to be displayed
for BIC.
Default is 3.}

\item{bpp_digits}{The number of
decimal places to be displayed
for BIC posterior probability
and prior probabilities.
Default is 3.}

\item{sort_models}{Whether the models
will be sorted by BIC posterior
probability.
Default is \code{TRUE}.}

\item{max_models}{The maximum number
of models to be printed. Default is
20.}

\item{bpp_target}{The desired
BIC probability. Used to compute
and print
the minimum prior probability
of the target model required to
achieve \code{bpp_target}. Default
is \code{NULL}.}

\item{...}{Optional arguments.
Ignored.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of
a \code{model_set}-class object.
}
\details{
It is the print method of the
output of \code{\link[=model_set]{model_set()}}.
}
\examples{

library(lavaan)

dat <- dat_path_model

mod <-
"
x3 ~ a*x1 + b*x2
x4 ~ a*x1
ab := a*b
"

fit <- sem(mod, dat_path_model, fixed.x = TRUE)

out <- model_set(fit)
out

}
\seealso{
A \code{model_set}-class object
is generated by \code{\link[=model_set]{model_set()}}.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
