% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_response.bayesian.R
\name{estimate_response}
\alias{estimate_response}
\alias{estimate_link}
\title{Generates predictions}
\usage{
estimate_response(
  model,
  data = NULL,
  transform = "response",
  random = FALSE,
  length = 25,
  preserve_range = TRUE,
  ...
)

estimate_link(
  model,
  data = "grid",
  transform = "response",
  random = FALSE,
  length = 25,
  preserve_range = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{data}{A data frame with model's predictors to estimate the response. If NULL, the model's data is used. If "grid", the model matrix is obtained (through \code{\link{visualisation_matrix}}).}

\item{transform}{Can be \code{"none"} (default for contrasts), \code{"response"} (default for means), \code{"mu"}, \code{"unlink"}, \code{"log"}. \code{"none"}  will leave the values on scale of the linear predictors. \code{"response"} will transform them on scale of the response variable. Thus for a logistic model, \code{"none"} will give estimations expressed in log-odds (probabilities on logit scale) and \code{"response"} in terms of probabilities.}

\item{random}{Should it take the random effects into account? Can be \code{TRUE}, \code{FALSE} or a formula indicating which group-level parameters to condition on when making predictions. The data argument may include new levels of the grouping factors that were specified when the model was estimated, in which case the resulting posterior predictions marginalize over the relevant variables (see \code{posterior_predict.stanreg}).}

\item{length}{Passed to \code{\link{visualisation_matrix}} if \code{data = "grid"}.}

\item{preserve_range}{Passed to \code{\link{visualisation_matrix}} if \code{data = "grid"}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame of predicted values.
}
\description{
See the documentation for your object's class:
\itemize{
 \item{\link[=estimate_response.stanreg]{Bayesian models (stanreg and brms)}}
 \item{\link[=estimate_response.glm]{Frequentist models}}
 }
\code{estimate_link} is a shortcut to \code{estimate_response} with \code{data = "grid"}. \code{estimate_response} would be used in the context of generating actual predictions for the existing or new data, whereas \code{estimate_link} is more relevant in the context of visualisation and plotting.
}
