% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_contrasts.frequentist.R
\name{estimate_contrasts.lm}
\alias{estimate_contrasts.lm}
\title{Estimate contrasts}
\usage{
\method{estimate_contrasts}{lm}(
  model,
  levels = NULL,
  fixed = NULL,
  modulate = NULL,
  transform = "none",
  length = 10,
  standardize = TRUE,
  standardize_robust = FALSE,
  ci = 0.95,
  adjust = "holm",
  ...
)
}
\arguments{
\item{model}{A Bayesian model.}

\item{levels}{A character vector or formula specifying the names of the predictors over which to estimate means or contrasts.}

\item{fixed}{A character vector indicating the names of the predictors to be "fixed" (i.e., maintained), so that the estimation is made at these values.}

\item{modulate}{A character vector indicating the names of a numeric variable along which the means or the contrasts will be estimated. Adjust its length using \code{length}.}

\item{transform}{Can be \code{"none"} (default for contrasts), \code{"response"} (default for means), \code{"mu"}, \code{"unlink"}, \code{"log"}. \code{"none"}  will leave the values on scale of the linear predictors. \code{"response"} will transform them on scale of the response variable. Thus for a logistic model, \code{"none"} will give estimations expressed in log-odds (probabilities on logit scale) and \code{"response"} in terms of probabilities.}

\item{length}{Length of the spread numeric variables.}

\item{standardize}{If \code{TRUE}, adds standardized differences or coefficients.}

\item{standardize_robust}{Robust standardization through \code{MAD} (Median Absolute Deviation, a robust estimate of SD) instead of regular \code{SD}.}

\item{ci}{Credible Interval (CI) level. Default to 0.89 (89\%). See \code{\link[bayestestR]{ci}} for further details.}

\item{adjust}{The p-values adjustment method for multi-comparisons. Can be one of "holm" (default), "tukey", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr" or "none". See the p-value adjustment section in the \code{emmeans::test} documentation.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A dataframe of estimated contrasts.
}
\description{
Estimate contrasts
}
\examples{
library(modelbased)

model <- lm(Sepal.Width ~ Species, data = iris)
estimate_contrasts(model)

model <- lm(Sepal.Width ~ Species * Petal.Width, data = iris)
estimate_contrasts(model)
estimate_contrasts(model, fixed = "Petal.Width")
estimate_contrasts(model, modulate = "Petal.Width", length = 4)


if (require("lme4")) {
  data <- iris
  data$Petal.Length_factor <- ifelse(data$Petal.Length < 4.2, "A", "B")

  model <- lmer(Sepal.Width ~ Species + (1 | Petal.Length_factor), data = data)
  estimate_contrasts(model)
}
}
