% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.estimates.R
\name{print.estimates}
\alias{print.estimates}
\title{Predictive Accuracy Report}
\usage{
\method{print}{estimates}(x, ...)
}
\arguments{
\item{x}{An object of class 'predictive.acc' returned by
\code{"\link[=predictive.acc]{predictive.acc()}"} function}

\item{\dots}{Additional arguments to print method}
}
\description{
Predictive Accuracy Report
}
\examples{
\dontrun{
library(mlbench)
set.seed(1111)
# Random Forest analysis of model based recursive partitioning load data
data("BostonHousing", package = "mlbench")
BostonHousing <- BostonHousing[1:90, c("rad", "tax", "crim", "medv", "lstat")]

# Recursive partitioning based on linear regression model medv ~ lstat with 3
# trees.  1 core/processor used. 
rfout <- mobforest.analysis(as.formula(medv ~ lstat), c("rad", "tax", "crim"),
    mobforest_controls = mobforest.control(ntree = 3, mtry = 2, replace = T,
        alpha = 0.05, bonferroni = T, minsplit = 25), data = BostonHousing,
    processors = 1, model = linearModel, seed = 1111)
# prints predictive accuracy output
pacc <- predictive.acc(rfout)
}

}
