% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.acc.R
\name{logistic.acc}
\alias{logistic.acc}
\title{Contingency table: Predicted vs. Observed Outcomes}
\usage{
logistic.acc(response, predicted, prob_thresh = 0.5)
}
\arguments{
\item{response}{A vector of binary classes of out-of-cases for a given tree.}

\item{predicted}{A vector of predicted probabilities of out-of-cases using
same tree.}

\item{prob_thresh}{Probability threshold for classification (default = .5).}
}
\description{
This function takes predicted probabilities (for out of bag cases) obtained
through logistic regression-based tree models and converts them into binary
classes (based on specified probability threshold). The predicted
classifications are then compared to actual binary response.
}
\examples{
# We should get 15 predictions correct and miss 5
response <- matrix(c(rep(0,10), rep(1,10)))
predicted <- c(rep(.1,15), rep(.8,5))
logistic.acc(response, predicted, .5)	

}
