% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_woe.R
\name{cal_woe}
\alias{cal_woe}
\title{Perform WoE transformation of a numeric variable}
\usage{
cal_woe(data, xname, spec)
}
\arguments{
\item{data}{A input dataframe}

\item{xname}{The name string of X with numeric values to which the WoE is applied}

\item{spec}{The output table from the binning function, e.g. qtl_bin() or iso_bin()}
}
\value{
A list of WoE transformation outputs, including a dataframe with the transformed variable and a PSI summary
}
\description{
The function \code{cal_woe} performs the WoE transformation of a numeric variable based on the output 
specification from a binning function, e.g. qtl_bin() or iso_bin().
}
\examples{
data(hmeq)
bin_out <- qtl_bin(hmeq, BAD, DEROG)
cal_woe(hmeq, "DEROG", bin_out$df)
}
