% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.HV}
\alias{test.HV}
\title{The Henze-Visagie test of multivariate normality}
\usage{
test.HV(data, a = 5, MC.rep = 10000, alpha = 0.05)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{a}{positive numeric number (tuning parameter).}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value.}

\item{alpha}{level of significance of the test.}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$param}}{value tuning parameter.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}
}
}
\description{
Computes the multivariate normality test of Henze and Visagie (2019).
}
\details{
This functions evaluates the teststatistic with the given data and the specified tuning parameter \code{a}.
Each row of the data Matrix contains one of the n (multivariate) sample with dimension d. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the test returns an error.

Note that \code{a=Inf} returns the limiting test statistic with value \code{2*\link{MSkew} + \link{MRSSkew}}.
}
\examples{
test.HV(MASS::mvrnorm(50,c(0,1),diag(1,2)),a=5,MC.rep=500)
test.HV(MASS::mvrnorm(50,c(0,1),diag(1,2)),a=Inf,MC.rep=500)

}
\references{
Henze, N., Visagie, J. (2019) "Testing for normality in any dimension based on a partial differential equation involving the moment generating function", to appear in Ann. Inst. Stat. Math., \href{https://doi.org/10.1007/s10463-019-00720-8}{DOI}
}
\seealso{
\code{\link{HV}}
}
