% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-nse.R
\name{flat_expr}
\alias{flat_expr}
\alias{flatten_call}
\alias{flatten_expr}
\title{Flatten Expressions for Non-standard Evaluation}
\usage{
flatten_call(call)

flatten_expr(expr)
}
\arguments{
\item{call, expr}{(\code{language})\cr a language object to flatten.}
}
\value{
A list of atomic values, symbols, infix operator names and
subexpressions.
}
\description{
Used primarily to support the parsing of covariance structure definitions
from formulas, these functions flatten the syntax tree into a hierarchy-less
grammar, allowing for parsing that doesn't abide by R's native operator
precedence.
}
\details{
Where \code{1 + 2 | 3} in R's syntax tree is \code{(|, (+, 1, 2), 3)},
flattening it into its visual order produces \code{(1, +, 2, |, 3)}, which
makes for more fluent interpretation of non-standard grammar rules used in
formulas.
}
\section{Functions}{
\itemize{
\item \code{flatten_call()}: Flatten a call into a list of names and argument expressions.

The call name and all arguments are flattened into the same list, meaning a
call of the form \code{sp_exp(a, b, c | d / e)} produces a list of the form
\code{(sp_exp, a, b, c, |, d, /, e)}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{flatten_call(quote(sp_exp(a, b, c | d / e)))
}\if{html}{\out{</div>}}

\item \code{flatten_expr()}: Flatten nested expressions

\if{html}{\out{<div class="sourceCode">}}\preformatted{flatten_expr(quote(1 + 2 + 3 | 4))
}\if{html}{\out{</div>}}

}}
\keyword{internal}
