% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component.R
\name{component}
\alias{component}
\title{Component Access for \code{mmrm_tmb} Objects}
\usage{
component(
  object,
  name = c("cov_type", "subject_var", "n_theta", "n_subjects", "n_timepoints", "n_obs",
    "beta_vcov", "beta_vcov_complete", "varcor", "formula", "dataset", "n_groups",
    "reml", "convergence", "evaluations", "method", "optimizer", "conv_message", "call",
    "theta_est", "beta_est", "beta_est_complete", "beta_aliased", "x_matrix", "y_vector",
    "neg_log_lik", "jac_list", "theta_vcov", "full_frame", "xlev", "contrasts")
)
}
\arguments{
\item{object}{(\code{mmrm_tmb})\cr the fitted MMRM.}

\item{name}{(\code{character})\cr the component(s) to be retrieved.}
}
\value{
The corresponding component of the object, see details.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
Available \code{component()} names are as follows:
\itemize{
\item \code{call}: low-level function call which generated the model.
\item \code{formula}: model formula.
\item \code{dataset}: data set name.
\item \code{cov_type}: covariance structure type.
\item \code{n_theta}: number of parameters.
\item \code{n_subjects}: number of subjects.
\item \code{n_timepoints}: number of modeled time points.
\item \code{n_obs}: total number of observations.
\item \code{reml}: was REML used (ML was used if \code{FALSE}).
\item \code{neg_log_lik}: negative log likelihood.
\item \code{convergence}: convergence code from optimizer.
\item \code{conv_message}: message accompanying the convergence code.
\item \code{evaluations}: number of function evaluations for optimization.
\item \code{method}: Adjustment method which was used (for \code{mmrm} objects),
otherwise \code{NULL} (for \code{mmrm_tmb} objects).
\item \code{beta_vcov}: estimated variance-covariance matrix of coefficients
(excluding aliased coefficients). When Kenward-Roger/Empirical adjusted
coefficients covariance matrix is used, the adjusted covariance matrix is returned (to still obtain the
original asymptotic covariance matrix use \code{object$beta_vcov}).
\item \code{beta_vcov_complete}: estimated variance-covariance matrix including
aliased coefficients with entries set to \code{NA}.
\item \code{varcor}: estimated covariance matrix for residuals. If there are multiple
groups, a named list of estimated covariance matrices for residuals will be
returned. The names are the group levels.
\item \code{theta_est}: estimated variance parameters.
\item \code{beta_est}: estimated coefficients (excluding aliased coefficients).
\item \code{beta_est_complete}: estimated coefficients including aliased coefficients
set to \code{NA}.
\item \code{beta_aliased}: whether each coefficient was aliased (i.e. cannot be estimated)
or not.
\item \code{theta_vcov}:  estimated variance-covariance matrix of variance parameters.
\item \code{x_matrix}: design matrix used (excluding aliased columns).
\item \code{xlev}: 	a named list of character vectors giving the full set of levels to be assumed for each factor.
\item \code{contrasts}: a list of contrasts used for each factor.
\item \code{y_vector}: response vector used.
\item \code{jac_list}: Jacobian, see  \code{\link[=h_jac_list]{h_jac_list()}} for details.
\item \code{full_frame}: \code{data.frame} with \code{n} rows containing all variables needed in the model.
}
}
\examples{
fit <- mmrm(
  formula = FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID),
  data = fev_data
)
# Get all available components.
component(fit)
# Get convergence code and message.
component(fit, c("convergence", "conv_message"))
# Get modeled formula as a string.
component(fit, c("formula"))

}
\seealso{
In the \code{lme4} package there is a similar function \code{getME()}.
}
