% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fmetric.r
\name{fmetric}
\alias{fmetric}
\title{Compute Filter-based Metrics in the Functional Space Between Marked Point Processes}
\usage{
fmetric(S1, S2, measure = "sim", h = "laplacian", tau = 1, M = NULL,
  abs.tol = .Machine$double.eps^0.25)
}
\arguments{
\item{S1}{marked point process data}

\item{S2}{marked point process data}

\item{measure}{\code{"sim"} for similarity and \code{"dist"} for distance. Default \code{"sim"}.}

\item{h}{filtering function. Default \code{"laplacian"} offers significant computational advantage. A function can be specified here like
\code{h=function(x,tau) exp(-x^2/tau)}.}

\item{tau}{parameter for filtering function.}

\item{M}{a precision matrix for filter of marks, i.e., exp( - r' M r) is used for filtering marks. It should be symmetric and positive semi-definite.}

\item{abs.tol}{absolute tolerance for numerical integration.}
}
\value{
similarity or distance between two inputs (marked) point process S1 and S2.
}
\description{
The most commonly used and intensively studied metrics for spike trains, which is based on the continuation of event sequence to a real valued continuous function using a smoother function.
}
\details{
\code{fmetric} computes filter-based measure between MPP instances. Discrete event timings are transformed into a continuous function by using a kernel smoother, and usual l2 inner product is adopted for defining the similarity between two point process instances.
}
\examples{
##The aftershock data of 26th July 2003 earthquake of M6.2 at the northern Miyagi-Ken Japan.
data(Miyagi20030626)
##  no. longitude latitude magnitude  time  depth year month day
## split events by 7-day
sMiyagi <- splitMPP(Miyagi20030626,h=60*60*7,scaleMarks=TRUE)$S
N <- 10
tau <- 0.1
sMat <- matrix(0,N,N)
  cat("calculating fmetric with tau ",tau,"...")
 for(i in 1:(N)){
   cat(i," ")
   for(j in i:N){
     S1 <- sMiyagi[[i]]$time;S2 <- sMiyagi[[j]]$time
    sMat[i,j] <- fmetric(S1,S2,tau=tau,M=diag(1,4))
   }
 }
 sMat <- sMat+t(sMat)
 tmpd <- diag(sMat) <- diag(sMat)/2
 sMat <- sMat/sqrt(outer(tmpd,tmpd))
image(sMat)
}
\author{
Hideitsu Hino \email{hinohide@cs.tsukuba.ac.jp}, Ken Takano, Yuki Yoshikawa, and Noboru Murata
}
\references{
M. C. W. van Rossum. 2001. A Novel Spike Distance. Neural Comput. 13, 4 (April 2001), 751-763.

S. Schreiber, J.M. Fellous, P.H. Tiesinga, T.J. Sejnowski, A new correlation-based measure of spike timing reliability, Neurocomputing 2003; 52-54:925--31
}

