% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_cimrob.R
\name{info}
\alias{info}
\title{Extract Model Information for Cluster-Adjusted Robust Inference}
\usage{
info(formula = NULL, cluster, dat, robmod)
}
\arguments{
\item{formula}{A formula used in the model fitting.}

\item{cluster}{A formula or a character string indicating the clustering
variable in \code{dat}.}

\item{dat}{A data frame containing the data used in the model.}

\item{robmod}{A robust model object from which to extract information.}
}
\value{
A list containing the following elements:
\describe{
\item{variables}{Vector of all variable names used in the model.}
\item{clust.name}{Name of the clustering variable.}
\item{dat}{Filtered data set containing only the observations used in the
model.}
\item{clust}{Vector representing the cluster index for each observation in
\code{dat}.}
\item{ind.variables.full}{Names of all independent variables including
dropped ones, if any, in the model.}
\item{ind.variables}{Names of non-dropped independent variables used in the
model.}
}
}
\description{
This internal function extracts essential information from a model object and
associated data, specifically for use in cluster-adjusted robust inference
functions like \code{cluster_im_glmRob} and \code{cluster_im_lmRob}. It handles variable
extraction, clustering information, and filtering the dataset based on the
model's usage.
}
\keyword{internal}
