% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CloseCATs.R
\name{CloseCATs}
\alias{CloseCATs}
\title{CloseCATs Shiny Application}
\usage{
CloseCATs()
}
\value{
A Shiny app object which can be run to start the application.
}
\description{
This function creates and runs a Shiny application for the CloseCATs game.
The application provides a user interface for setting up the game, dealing cards,
swapping cards, and scoring the game based on statistical computations. The
game involves dealing cards to players and the computer, allowing the player
to swap cards in their column, and scoring the game based on the
mispecification distance calculated from the processed hands.
}
\details{
The UI allows players to input various statistical parameters and preferences
for the game setup. It also provides interactive elements for dealing cards,
swapping cards within a column, and scoring the game based on the calculated
mispecification distance.

The main components of the Shiny application include:
\itemize{
\item A sidebar for inputting game parameters and controls for dealing and scoring.
\item A main panel for displaying game cards, swap options, and results.
\item Reactive elements that update based on user interaction and game state.
}
}
\examples{
# To run the CloseCATs Shiny application:
if(interactive()){
  CloseCATs()
}

}
