% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initCrit.R
\name{initCrit}
\alias{initCrit}
\title{Initialize an MBO infill criterion.}
\usage{
initCrit(crit, fun, design, learner, control)
}
\arguments{
\item{crit}{[\code{\link{MBOInfillCrit}}]\cr
Uninitialized infill criterion.}

\item{fun}{[\code{smoof_function}]\cr
Fitness function to optimize.}

\item{design}{Sampling plan.}

\item{learner}{[\code{\link[mlr]{Learner}}]\cr
Regression learner from mlr, which is used as a surrogate to model our fitness function.}

\item{control}{[\code{\link{MBOControl}}]\cr
MBO control object.}
}
\value{
[\code{\link{MBOInfillCrit}}]
}
\description{
Some infill criteria have parameters that are dependent on values in the parameter set, design,
  used learner or other control settings.
  To actually set these default values, this function is called, which returns a fully
  initialized [\code{\link{MBOInfillCrit}}].
  This function is mainly for internal use. If a custom infill criterion is created, it may be
  required to create a separate method \code{initCrit.InfillCritID} where \code{ID} is the
  \code{id} of the custom \link{MBOInfillCrit}.
}
