% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampleRun.R
\name{exampleRun}
\alias{exampleRun}
\title{Perform an mbo run on a test function and and visualize what happens.}
\usage{
exampleRun(fun, design = NULL, learner = NULL, control,
  points.per.dim = 50, noisy.evals = 10,
  show.info = getOption("mlrMBO.show.info", TRUE))
}
\arguments{
\item{fun}{[\code{smoof_function}]\cr
Fitness function to optimize.
For one dimensional target functions you can obtain a \code{smoof_function} by using \code{\link[smoof]{makeSingleObjectiveFunction}}.
For multi dimensional functions use \code{\link[smoof]{makeMultiObjectiveFunction}}.
It is possible to return even more information which will be stored
in the optimization path. To achieve this, simply append the attribute \dQuote{extras}
to the return value of the target function. This has to be a named list of scalar values.
Each of these values will be stored additionally in the optimization path.}

\item{design}{[\code{data.frame}]\cr
Initial design as data frame.
If the y-values are not already present in design, mbo will evaluate the points.
If the parameters have corresponding trafo functions, the design must not be transformed before it is passed!
Functions to generate designs are available in \code{ParamHelpers}: \code{\link[ParamHelpers]{generateDesign}}, \code{\link[ParamHelpers]{generateGridDesign}}, \code{\link[ParamHelpers]{generateRandomDesign}}.
Default is \code{NULL}, which means \code{\link[ParamHelpers]{generateDesign}} is called and a design of size 4 times number of all parameters is created
The points are drawn via \code{\link[lhs]{maximinLHS}} to maximize the minimal distance between design points.}

\item{learner}{[\code{\link[mlr]{Learner}}]\cr
Regression learner from mlr, which is used as a surrogate to model our fitness function.
If \code{NULL} (default), the default learner is determined as described here: \link{mbo_default_learner}.}

\item{control}{[\code{\link{MBOControl}}]\cr
Control object for mbo.}

\item{points.per.dim}{[\code{integer}]\cr
Number of (regular spaced) locations at which to
sample the \code{fun} function per dimension.
Default is 50.}

\item{noisy.evals}{[\code{integer(1)}]\cr
Number of function evaluations per point if \code{fun} is noisy.
Default is 10.}

\item{show.info}{[\code{logical(1)}]\cr
Verbose output on console?
Default is \code{TRUE}.}
}
\value{
[\code{MBOExampleRun}]
}
\description{
Usually used for 1D or 2D examples,
useful for figuring out how stuff works and for teaching purposes.
Currently only parameter spaces with numerical parameters are supported.
For visualization, run \code{plotExampleRun} on the resulting object.
What is displayed is documented here: \code{\link{plotExampleRun}}.
Rendering the plots without displaying them is possible via the function
\code{\link{renderExampleRunPlot}}.

Please note the following things:
- The true objective function (and later everything which is predicted from our surrogate model)
  is evaluated on a regular spaced grid. These evaluations are stored in the result object.
  You can control the resultion of this grid via \code{points.per.dim}.
  Parallelization of these evaluations is possible with the R package parallelMap on the level \code{mlrMBO.feval}.
- In every iteration the fitted, approximating surrogate model is stored in the result object
  (via \code{store.model.at} in \code{control}) so we can later visualize it quickly.
- The global optimum of the function (if defined) is extracted from the passed smoof function.
- If the passed objective function \code{fun} does not provide the true, unnoisy objective function
  some features will not be displayed (for example the gap between the best point so far and the global optimum).
}
