% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RetrafoState.R
\name{getCPOTrainedState}
\alias{getCPOTrainedState}
\title{Get the Internal State of a CPORetrafo Object}
\usage{
getCPOTrainedState(trained.object)
}
\arguments{
\item{trained.object}{[\code{CPOTrained}]\cr
The object to get the state of.}
}
\value{
[\code{list}]. A named list, containing the complete internal state of the \code{\link{CPOTrained}}.
}
\description{
A \code{\link{CPOTrained}} always has access to some kind of state
that represents information gotten from the training data,
as well as the parameters it was called with.

Only primitive \code{\link{CPOTrained}} objects can be inspected like this.
If the supplied \code{\link{CPOTrained}} is not primitive, split it into
its constituents using \code{\link{as.list.CPOTrained}}.

The structure of the internal state depends on the \code{\link{CPO}} backend
used. For Functional CPO, the state is the environment of the
retrafo function, turned into a list. For Object based CPO,
the state is a list containing the parameters, as well as the
control object generated by the trafo function.

The object can be slightly modified and used to create a new
CPOTrained object using \code{\link{makeCPOTrainedFromState}}.
}
\seealso{
Other state functions: 
\code{\link{makeCPOTrainedFromState}()}

Other retrafo related: 
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{\%>>\%}()},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{clearRI}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOName}()},
\code{\link{getCPOOperatingType}()},
\code{\link{getCPOPredictType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{is.retrafo}()},
\code{\link{makeCPOTrainedFromState}()},
\code{\link{pipeCPO}()},
\code{\link{print.CPOConstructor}()}

Other inverter related: 
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{\%>>\%}()},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{clearRI}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOName}()},
\code{\link{getCPOOperatingType}()},
\code{\link{getCPOPredictType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{is.inverter}()},
\code{\link{makeCPOTrainedFromState}()},
\code{\link{pipeCPO}()},
\code{\link{print.CPOConstructor}()}
}
\concept{inverter related}
\concept{retrafo related}
\concept{state functions}
