% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task_regr_cookfarm_profiles.R
\docType{data}
\name{mlr_tasks_cookfarm}
\alias{mlr_tasks_cookfarm}
\alias{cookfarm_mlr3}
\title{Cookfarm Profiles Regression Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskRegr}.
}
\usage{
data(cookfarm_mlr3)
}
\description{
The R.J. Cook Agronomy Farm (cookfarm) is a Long-Term Agroecosystem Research
Site operated by Washington State University, located near Pullman,
Washington, USA. Contains spatio-temporal (3D+T) measurements of three soil
properties and a number of spatial and temporal regression covariates.

Here, only the "Profiles" dataset is used from the collection.
The \code{Date} column was appended from the \code{readings} dataset.
In addition coordinates were appended to the task as variables \code{"x"} and \code{"y"}.

The dataset was borrowed and adapted from package GSIF which was on archived on
CRAN in 2021-03.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("cookfarm")
tsk("cookfarm_mlr3")
}\if{html}{\out{</div>}}
}

\section{Column roles}{

The task has set column roles "space" and "time" for variables \code{"Date"} and
\code{"SOURCEID"}, respectively.
These are used by certain methods during partitioning, e.g.,
\code{mlr_resamplings_sptcv_cstf} with variant "Leave-location-and-time-out".
If only one of space or time should left out, the column roles must be
adjusted by the user!
}

\references{
Gasch, C.K., Hengl, T., Gräler, B., Meyer, H., Magney, T., Brown, D.J., 2015.
Spatio-temporal interpolation of soil water, temperature, and electrical
conductivity in 3D+T: the Cook Agronomy Farm data set. Spatial Statistics,
14, pp.70–90.

Gasch, C.K., D.J. Brown, E.S. Brooks, M. Yourek, M. Poggio, D.R. Cobos, C.S.
Campbell, 2016? Retroactive calibration of soil moisture sensors using a
two-step, soil-specific correction. Submitted to Vadose Zone Journal.

Gasch, C.K., D.J. Brown, C.S. Campbell, D.R. Cobos, E.S. Brooks, M. Chahal,
M. Poggio, 2016? A field-scale sensor network data set for monitoring and
modeling the spatial and temporal variation of soil moisture in a dryland
agricultural field. Submitted to Water Resources Research.
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}

\code{as.data.table(mlr_tasks)} for a complete table of all (also dynamically created) \link[=Task]{Tasks}.

Other Task: 
\code{\link{TaskClassifST}},
\code{\link{TaskRegrST}},
\code{\link{mlr_tasks_diplodia}},
\code{\link{mlr_tasks_ecuador}}
}
\concept{Task}
\keyword{datasets}
