% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.ResamplingSpCVTiles}
\alias{autoplot.ResamplingSpCVTiles}
\alias{autoplot.ResamplingRepeatedSpCVTiles}
\alias{plot.ResamplingSpCVTiles}
\alias{plot.ResamplingRepeatedSpCVTiles}
\title{Visualization Functions for SpCV Tiles Method.}
\usage{
\method{autoplot}{ResamplingSpCVTiles}(
  object,
  task,
  fold_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  repeats_id = NULL,
  show_omitted = FALSE,
  ...
)

\method{autoplot}{ResamplingRepeatedSpCVTiles}(
  object,
  task,
  fold_id = NULL,
  repeats_id = 1,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  show_omitted = FALSE,
  ...
)

\method{plot}{ResamplingSpCVTiles}(x, ...)

\method{plot}{ResamplingRepeatedSpCVTiles}(x, ...)
}
\arguments{
\item{object}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSpCVBlock} or
\link{ResamplingRepeatedSpCVBlock}.}

\item{task}{\verb{[TaskClassifST]/[TaskRegrST]}\cr
mlr3 task object.}

\item{fold_id}{\verb{[numeric]}\cr
Fold IDs to plot.}

\item{plot_as_grid}{\verb{[logical(1)]}\cr
Should a gridded plot using via \CRANpkg{patchwork} be created? If \code{FALSE}
a list with of \CRANpkg{ggplot2} objects is returned.
Only applies if a numeric vector is passed to argument \code{fold_id}.}

\item{train_color}{\verb{[character(1)]}\cr
The color to use for the training set observations.}

\item{test_color}{\verb{[character(1)]}\cr
The color to use for the test set observations.}

\item{repeats_id}{\verb{[numeric]}\cr
Repetition ID to plot.}

\item{show_omitted}{\verb{[logical]}\cr
Whether to show points not used in train or test set for the current fold.}

\item{...}{Passed to \code{geom_sf()}. Helpful for adjusting point sizes and
shapes.}

\item{x}{\verb{[Resampling]}\cr
mlr3 spatial resampling object. One of class \link{ResamplingSpCVBuffer},
\link{ResamplingSpCVBlock}, \link{ResamplingSpCVCoords}, \link{ResamplingSpCVEnv}.}
}
\description{
Generic S3 \code{plot()} and \code{autoplot()} (ggplot2) methods to
visualize mlr3 spatiotemporal resampling objects.
}
\details{
Specific combinations of arguments of \code{"spcv_tiles"} remove some
observations, hence \code{show_omitted} has an effect in some cases.
}
\examples{
\donttest{
if (mlr3misc::require_namespaces("sf", quietly = TRUE)) {
  library(mlr3)
  library(mlr3spatiotempcv)
  task = tsk("ecuador")
  resampling = rsmp("spcv_tiles",
    nsplit = c(4L, 3L), reassign = FALSE)
  resampling$instantiate(task)

  autoplot(resampling, task,
    fold_id = 1,
    show_omitted = TRUE, size = 0.7) *
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))
}
}
}
\seealso{
\itemize{
\item mlr3book chapter on \href{https://mlr3book.mlr-org.com/special-tasks.html#vis-spt-partitions}{"Spatiotemporal Visualization"}
\item Vignette \href{https://mlr3spatiotempcv.mlr-org.com/articles/spatiotemp-viz.html}{Spatiotemporal Visualization}.
\item \code{\link[=autoplot.ResamplingSpCVBlock]{autoplot.ResamplingSpCVBlock()}}
\item \code{\link[=autoplot.ResamplingSpCVBuffer]{autoplot.ResamplingSpCVBuffer()}}
\item \code{\link[=autoplot.ResamplingSpCVCoords]{autoplot.ResamplingSpCVCoords()}}
\item \code{\link[=autoplot.ResamplingSpCVDisc]{autoplot.ResamplingSpCVDisc()}}
\item \code{\link[=autoplot.ResamplingSpCVEnv]{autoplot.ResamplingSpCVEnv()}}
\item \code{\link[=autoplot.ResamplingCV]{autoplot.ResamplingCV()}}
\item \code{\link[=autoplot.ResamplingSptCVCluto]{autoplot.ResamplingSptCVCluto()}}
}
}
