% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvRanger.R
\name{LearnerSurvRanger}
\alias{LearnerSurvRanger}
\alias{mlr_learners_surv.ranger}
\title{Ranger Survival Forest Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[ranger:ranger]{ranger::ranger()}}.
\itemize{
\item distr is predicted using \code{\link[ranger:predict.ranger]{ranger::predict.ranger()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}
}
\section{Construction}{
\preformatted{LearnerSurvRanger$new()
mlr_learners$get("surv.ranger")
lrn("surv.ranger")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{distr, crank}
\item Feature Types: \verb{logical, integer, numeric, character, factor, ordered}
\item Packages: \CRANpkg{ranger} \CRANpkg{distr6}
}
}

\references{
\cite{mlr3proba}{wright_2017}

\cite{mlr3proba}{breiman_2001}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvObliqueRSF}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
