% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpCrankCompositor.R
\name{PipeOpCrankCompositor}
\alias{PipeOpCrankCompositor}
\alias{mlr_pipeops_crankcompositor}
\title{PipeOpCrankCompositor}
\format{\code{\link{R6Class}} inheriting from \code{\link{PipeOp}}.}
\description{
Uses a predicted \code{distr} in a \link{PredictionSurv} to estimate (or 'compose') a \code{crank} prediction.
}
\section{Construction}{
\preformatted{PipeOpCrankCompositor$new(id = "crankcompose", param_vals = list(method = "mean"))
}
\itemize{
\item \code{id} :: \code{character(1)} \cr
Identifier of the resulting  object, default \code{"crankcompose"}.
\item \code{param_vals} :: named \code{list} \cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\link{PipeOpCrankCompositor} has one input channel named "input", which takes
\code{NULL} during training and \link{PredictionSurv} during prediction.

\link{PipeOpCrankCompositor} has one output channel named "output", producing \code{NULL} during training
and a \link{PredictionSurv} during prediction.

The output during prediction is the \link{PredictionSurv} from the "pred" input but with the \code{crank}
predict type overwritten by the given estimation method.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\itemize{
\item \code{method} :: \code{character(1)} \cr
Determines what method should be used to produce a continuous ranking from the distribution.
One of \code{median} or \code{mean} corresponding to the respective functions in the predicted
survival distribution. Note that for models with a proportional hazards form, the ranking
implied by \code{mean} and \code{median} will be identical (but not the value of \code{crank} itself).
Default is \code{mean}.
}
}

\section{Internals}{

The \code{median} or \code{mean} will use analytical expressions if possible but if not they are calculated
using \link[distr6:median.Distribution]{distr6::median.Distribution} or \link[distr6:mean.Distribution]{distr6::mean.Distribution} respectively.
}

\section{Fields}{

Only fields inherited from \link{PipeOp}.
}

\section{Methods}{

Only methods inherited from \link{PipeOp}.
}

\examples{
library(mlr3)
library(mlr3pipelines)
set.seed(1)

# Three methods to predict a `crank` from `surv.rpart`
task = tgen("simsurv")$generate(30)

# Method 1 - Train and predict separately then compose
learn = lrn("surv.coxph")$train(task)$predict(task)
poc = po("crankcompose", param_vals = list(method = "mean"))
poc$predict(list(learn))

# Examples not run to save run-time.
\dontrun{
# Method 2 - Create a graph manually
gr = Graph$new()$
  add_pipeop(po("learner", lrn("surv.ranger")))$
  add_pipeop(po("crankcompose"))$
  add_edge("surv.ranger", "crankcompose")
gr$train(task)
gr$predict(task)

# Method 3 - Syntactic sugar: Wrap the learner in a graph
ranger.crank = crankcompositor(learner = lrn("surv.ranger"),
                            method = "median")
resample(task, ranger.crank, rsmp("cv", folds = 2))$predictions()
}
}
\seealso{
\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp} and \link{crankcompositor}

Other survival compositors: 
\code{\link{PipeOpDistrCompositor}}
}
\concept{survival compositors}
