% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvUnoC.R
\name{MeasureSurvUnoC}
\alias{MeasureSurvUnoC}
\alias{mlr_measures_surv.unoC}
\title{Uno's C-Index Survival Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{MeasureSurv}.}
\description{


Calls \code{\link[survAUC:UnoC]{survAUC::UnoC()}}.

Assumes random censoring.
}
\details{
All measures implemented from \CRANpkg{survAUC} should be used with care, we are aware
of problems in implementation that sometimes cause fatal errors in R. In future updates these
measures will all be re-written and implemented directly in \code{mlr3proba}.
}
\section{Construction}{
\preformatted{MeasureSurvUnoC$new(times, lp_thresh)
mlr_measures$get("surv.unoC")
msr("surv.unoC")
}
\itemize{
\item \code{times} :: \code{vector()} \cr If \code{integrate == TRUE} then a vector of time-points over which to integrate the score. If \code{integrate == FALSE} then a single time point at which to return the score. \cr
\item \code{lp_thresh} :: \code{numeric(1)} \cr Determines where to threshold the linear predictor for calculating the TPR/TNR. \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{crank}
}
}

\section{Fields}{

See \link{MeasureSurv}, as well as all variables passed to the constructor.
}

\references{
Uno, H., T. Cai T, M. J. Pencina, R. B. D'Agostino and W. L. Wei. (2011). \cr
On the C-statistics for evaluating overall adequacy of risk prediction procedures with censored
survival data.\cr
Statistics in Medicine. 30(10): 1105–1117.\cr
\doi{10.1002/sim.4154}
}
\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvHarrellC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}},
\code{\link{MeasureSurvXuR2}}

Other Concordance survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvHarrellC}}
}
\concept{Concordance survival measures}
\concept{survival measures}
