% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpOVR.R
\name{mlr_pipeops_ovrunite}
\alias{mlr_pipeops_ovrunite}
\alias{PipeOpOVRUnite}
\title{Unite Binary Classification Tasks}
\format{
\code{\link[R6:R6Class]{R6Class}} inheriting from \code{\link{PipeOpEnsemble}}/\code{\link{PipeOp}}.
}
\description{
Perform "One vs. Rest" classification by (weighted) majority vote prediction from \link[mlr3:PredictionClassif]{classification Predictions}. This works in combination with \code{\link{PipeOpOVRSplit}}.

Weights can be set as a parameter; if none are provided, defaults to equal weights for each
prediction.

Always returns a \code{"prob"} prediction, regardless of the incoming \code{\link[mlr3:Learner]{Learner}}'s
\verb{$predict_type}. The label of the class with the highest predicted probability is selected as the
\code{"response"} prediction.

Missing values during prediction are treated as each class label being equally likely.

This \code{\link{PipeOp}} uses a \code{\link{Multiplicity}} input, which is created by \code{\link{PipeOpOVRSplit}} and causes
\code{\link{PipeOp}}s on the way to this \code{\link{PipeOp}} to be called once for each individual \link[mlr3:TaskClassif]{binary Task}.

Note that \code{\link{Multiplicity}} is currently an experimental features and the implementation or UI
may change.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpOVRUnite$new(id = "ovrunite", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of the resulting object, default \code{"ovrunite"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpEnsemble}}. Instead of a
\code{\link[mlr3:Prediction]{Prediction}}, a \code{\link[mlr3:PredictionClassif]{PredictionClassif}} is used as
input and output during prediction and \code{\link{PipeOpEnsemble}}'s \code{collect} parameter is initialized
with \code{TRUE} to allow for collecting a \code{\link{Multiplicity}} input.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

The parameters are the parameters inherited from the \code{\link{PipeOpEnsemble}}.
}

\section{Internals}{

Inherits from \code{\link{PipeOpEnsemble}} by implementing the \code{private$.predict()} method.

Should be used in combination with \code{\link{PipeOpOVRSplit}}.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOpEnsemble}}/\code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpEnsemble}}/\code{\link{PipeOp}}.
}

\examples{
\dontshow{ if (requireNamespace("rpart")) \{ }
library(mlr3)
task = tsk("iris")
gr = po("ovrsplit") \%>>\% lrn("classif.rpart") \%>>\% po("ovrunite")
gr$train(task)
gr$predict(task)
gr$pipeops$classif.rpart$learner$predict_type = "prob"
gr$predict(task)
\dontshow{ \} }
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Ensembles: 
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_learners_avg}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_regravg}}

Other Multiplicity PipeOps: 
\code{\link{Multiplicity}()},
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_replicate}}

Other Experimental Features: 
\code{\link{Multiplicity}()},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_replicate}}
}
\concept{Ensembles}
\concept{Experimental Features}
\concept{Multiplicity PipeOps}
\concept{PipeOps}
