% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_task.R
\name{convert_task}
\alias{convert_task}
\title{Convert a task from its type to another.}
\usage{
convert_task(
  intask,
  new_target = NULL,
  new_type = NULL,
  drop_original_target = TRUE,
  drop_levels = FALSE,
  ...
)
}
\arguments{
\item{intask}{\code{\link[mlr3:Task]{Task}}\cr
A \code{\link[mlr3:Task]{Task}} to be converted.}

\item{new_target}{\code{character(1)} | \code{NULL}\cr
New target to be set, must be a column in the \code{intask} data.
If \code{NULL}, no new target is set, and task is converted as-is.}

\item{new_type}{\code{character(1)} | \code{NULL}\cr
The new task type. Must be in \code{mlr_reflections$task_types}.
If \code{NULL} (default), a new task with the same task_type is created.}

\item{drop_original_target}{\code{logical(1)}\cr
If \code{TRUE} (default), the original target is dropped. Otherwise it is
added as a feature.}

\item{drop_levels}{\code{logical(1)}\cr
If \code{TRUE}, unused levels of the new target variable are dropped.}

\item{\dots}{\code{any}\cr
Further arguments passed to the constructor of the task.}
}
\value{
\code{\link[mlr3:Task]{Task}}
}
\description{
The task's target is replaced by a different column from the data.
#FIXME: This needs detailed tests and should be moved to mlr3.
}
