% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpRegrAvg.R
\name{mlr_pipeops_regravg}
\alias{mlr_pipeops_regravg}
\alias{PipeOpRegrAvg}
\title{PipeOpRegrAvg}
\format{\code{\link{R6Class}} inheriting from \code{\link{PipeOpEnsemble}}/\code{\link{PipeOp}}.}
\description{
Perform (weighted) prediction averaging from regression \code{\link[mlr3:Prediction]{Prediction}}s by connecting
\code{\link{PipeOpRegrAvg}} to multiple \code{\link{PipeOpLearner}} outputs.

The resulting \code{"response"} prediction is a weighted average of the incoming \code{"response"} predictions.
\code{"se"} prediction is currently not aggregated but discarded if present.

Weights can be set as a parameter; if none are provided, defaults to
equal weights for each prediction.
Defaults to equal weights for each model.
}
\section{Construction}{
\preformatted{PipeOpRegrAvg$new(innum = 0, id = "regravg", param_vals = list())
}
\itemize{
\item \code{innum} :: \code{numeric(1)}\cr
Determines the number of input channels.
If \code{innum} is 0 (default), a vararg input channel is created that can take an arbitrary number of inputs.
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, default \code{"regravg"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpEnsemble}}. Instead of a \code{\link[mlr3:Prediction]{Prediction}}, a \code{\link[mlr3:PredictionRegr]{PredictionRegr}}
is used as input and output during prediction.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

The parameters are the parameters inherited from the \code{\link{PipeOpEnsemble}}.
}

\section{Internals}{

Inherits from \code{\link{PipeOpEnsemble}} by implementing the \code{private$weighted_avg_predictions()} method.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOpEnsemble}}/\code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpEnsemble}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")

# Simple Bagging
gr = greplicate(n = 5,
  po("subsample") \%>>\%
  po("learner", lrn("classif.rpart"))
) \%>>\%
  po("classifavg")

resample(tsk("iris"), GraphLearner$new(gr), rsmp("holdout"))
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputenewlvl}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}

Other Ensembles: 
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_learners_avg}},
\code{\link{mlr_pipeops_classifavg}}
}
\concept{Ensembles}
\concept{PipeOps}
