% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLData.R
\name{OMLData}
\alias{OMLData}
\title{Interface to OpenML Data Sets}
\description{
This is the class for data sets served on \url{https://openml.org/d}.
}
\section{mlr3 Integration}{

A \link[mlr3:Task]{mlr3::Task} is returned by the method \verb{$task}.
Alternatively, you can convert this object to a \link[mlr3:DataBackend]{mlr3::DataBackend} using
\code{mlr3::as_data_backend()}.
}

\examples{
\donttest{
odata = OMLData$new(id = 9)

print(odata)
print(odata$target_names)
print(odata$feature_names)
print(odata$tags)
print(odata$task())

# get a task via tsk():
if (requireNamespace("mlr3")) {
  mlr3::tsk("oml", data_id = 9)
}
}
}
\references{
\cite{mlr3oml}{vanschoren2014}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML data id.}

\item{\code{cache_dir}}{(\code{logical(1)} | \code{character(1)})\cr
Stores the location of the cache for objects retrieved from \url{https://openml.org}.
If set to \code{FALSE}, caching is disabled.

The package \CRANpkg{qs} is required for caching.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{(\code{character(1)})\cr
Name of the data set, as extracted from the data set description.}

\item{\code{desc}}{(\code{list()})\cr
Data set description (meta information), downloaded and converted from the JSON API response.}

\item{\code{qualities}}{(\code{data.table()})\cr
Data set qualities (performance values), downloaded from the JSON API response and
converted to a \code{\link[data.table:data.table]{data.table::data.table()}} with columns \code{"name"} and \code{"value"}.}

\item{\code{features}}{(\code{data.table()})\cr
Information about data set features (including target), downloaded from the JSON API response and
converted to a \code{\link[data.table:data.table]{data.table::data.table()}} with columns:
\itemize{
\item \code{"index"} (\code{integer()}): Column position.
\item \code{"name"} (\code{character()}): Name of the feature.
\item \code{"data_type"} (\code{factor()}): Type of the feature: \code{"nominal"} or \code{"numeric"}.
\item \code{"nominal_value"} (\code{list()}): Levels of the feature, or \code{NULL} for numeric features.
\item \code{"is_target"} (\code{logical()}): \code{TRUE} for target column, \code{FALSE} otherwise.
\item \code{"is_ignore"} (\code{logical()}): \code{TRUE} if this feature should be ignored.
Ignored features are removed automatically from the data set.
\item \code{"is_row_identifier"} (\code{logical()}): \code{TRUE} if the column encodes a row identifier.
Row identifiers are removed automatically from the data set.
\item \code{"number_of_missing_values"} (\code{integer()}): Number of missing values in the column.
}}

\item{\code{data}}{(\code{data.table()})\cr
Data as \code{\link[data.table:data.table]{data.table::data.table()}}.
Columns marked as row identifiers or marked with the ignore flag are automatically removed.}

\item{\code{target_names}}{(\code{character()})\cr
Name of the default target, as extracted from the OpenML data set description.}

\item{\code{feature_names}}{(\code{character()})\cr
Name of the features, as extracted from the OpenML data set description.}

\item{\code{nrow}}{(\code{integer()})\cr
Number of observations, as extracted from the OpenML data set qualities.}

\item{\code{ncol}}{(\code{integer()})\cr
Number of features (including targets), as extracted from the table of data set features.
This excludes row identifiers and ignored columns.}

\item{\code{tags}}{(\code{character()})\cr
Returns all tags of the data set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{OMLData$new()}}
\item \href{#method-print}{\code{OMLData$print()}}
\item \href{#method-quality}{\code{OMLData$quality()}}
\item \href{#method-task}{\code{OMLData$task()}}
\item \href{#method-clone}{\code{OMLData$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new object of class \code{OMLData}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLData$new(id, cache = getOption("mlr3oml.cache", FALSE))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML data id.}

\item{\code{cache}}{(\code{logical(1)} | \code{character(1)})\cr
See field \code{cache} for an explanation of possible values.
Defaults to value of option \code{"mlr3oml.cache"}, or \code{FALSE} if not set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints the object.
For a more detailed printer, convert to a \link[mlr3:Task]{mlr3::Task} via \verb{$task()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLData$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quality"></a>}}
\if{latex}{\out{\hypertarget{method-quality}{}}}
\subsection{Method \code{quality()}}{
Returns the value of a single OpenML data set quality.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLData$quality(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(\code{character(1)})\cr
Name of the quality to extract.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-task"></a>}}
\if{latex}{\out{\hypertarget{method-task}{}}}
\subsection{Method \code{task()}}{
Creates a \link[mlr3:Task]{mlr3::Task} using the provided target column, defaulting to the default target attribute
of the task description.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLData$task(target_names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target_names}}{(\code{character()})\cr
Name(s) of the target columns, or \code{NULL} for the default columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
