% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulate.R
\name{formulate}
\alias{formulate}
\title{Create Formulas}
\usage{
formulate(lhs = NULL, rhs = NULL, env = NULL)
}
\arguments{
\item{lhs}{(\code{character(1)})\cr
Left-hand side of formula.}

\item{rhs}{(\code{character()})\cr
Right-hand side of formula. Multiple elements will be collapsed with \code{" + "}.}

\item{env}{(\code{environment()})\cr
Environment for the new formula. Defaults to \code{NULL}.}
}
\value{
\code{\link[stats:formula]{stats::formula()}}.
}
\description{
Given the left-hand side and right-hand side as character vectors, generates a new
\code{\link[stats:formula]{stats::formula()}}.
}
\examples{
formulate("Species", c("Sepal.Length", "Sepal.Width"))
formulate(rhs = c("Sepal.Length", "Sepal.Width"))
}
