% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penguins_simple.R
\docType{data}
\name{penguins_simple}
\alias{penguins_simple}
\alias{mlr_tasks_penguins_simple}
\title{Simplified Palmer Penguins Data Set}
\source{
\CRANpkg{palmerpenguins}
}
\description{
Classification data to predict the species of penguins from the \CRANpkg{palmerpenguins} package, see \link[palmerpenguins:penguins]{palmerpenguins::penguins}.
A better alternative to the \link[=iris]{iris data set}.
}
\section{Pre-processing}{

\itemize{
\item The unit of measurement have been removed from the column names.
Lengths are given in millimeters (mm), weight in gram (g).
\item Observations with missing values have been removed.
\item Factor variables are one-hot encoded.
}
}

\examples{
data("penguins_simple", package = "mlr3data")
str(penguins_simple)
}
\references{
Gorman KB, Williams TD, Fraser WR (2014).
\dQuote{Ecological Sexual Dimorphism and Environmental Variability within a Community of Antarctic Penguins (Genus Pygoscelis).}
\emph{PLoS ONE}, \bold{9}(3), e90081.
\doi{10.1371/journal.pone.0090081}.

\url{https://github.com/allisonhorst/palmerpenguins}
}
\keyword{data}
