% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_penguins.R
\name{mlr_tasks_penguins}
\alias{mlr_tasks_penguins}
\title{Palmer Penguins Data Set}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskClassif}.
}
\source{
\CRANpkg{palmerpenguins}
}
\description{
Classification data to predict the species of penguins from the \CRANpkg{palmerpenguins} package, see \link[palmerpenguins:penguins]{palmerpenguins::penguins}.
A better alternative to the \link[=iris]{iris data set}.
}
\section{Dictionary}{

This \link{Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_tasks} or with the associated sugar function \code{\link[=tsk]{tsk()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("penguins")
tsk("penguins")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{classif}
\item Dimensions: 344x8
\item Properties: \dQuote{multiclass}
\item Has Missings: \code{TRUE}
\item Target: \dQuote{species}
\item Features: \dQuote{bill_depth}, \dQuote{bill_length}, \dQuote{body_mass}, \dQuote{flipper_length}, \dQuote{island}, \dQuote{sex}, \dQuote{year}
}
}

\section{Pre-processing}{

\itemize{
\item The unit of measurement have been removed from the column names.
Lengths are given in millimeters (mm), weight in gram (g).
}
}

\references{
Gorman KB, Williams TD, Fraser WR (2014).
\dQuote{Ecological Sexual Dimorphism and Environmental Variability within a Community of Antarctic Penguins (Genus Pygoscelis).}
\emph{PLoS ONE}, \bold{9}(3), e90081.
\doi{10.1371/journal.pone.0090081}.

\url{https://github.com/allisonhorst/palmerpenguins}
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item Package \CRANpkg{mlr3data} for more toy tasks.
\item Package \CRANpkg{mlr3oml} for downloading tasks from \url{https://www.openml.org}.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[=Task]{Tasks} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3fselect} and \CRANpkg{mlr3filters} for feature selection and feature filtering.
\item Extension packages for additional task types:
\itemize{
\item Unsupervised clustering: \CRANpkg{mlr3cluster}
\item Probabilistic supervised regression and survival analysis: \url{https://mlr3proba.mlr-org.com/}.
}
}

Other Task: 
\code{\link{Task}},
\code{\link{TaskClassif}},
\code{\link{TaskRegr}},
\code{\link{TaskSupervised}},
\code{\link{TaskUnsupervised}},
\code{\link{california_housing}},
\code{\link{mlr_tasks}},
\code{\link{mlr_tasks_breast_cancer}},
\code{\link{mlr_tasks_german_credit}},
\code{\link{mlr_tasks_iris}},
\code{\link{mlr_tasks_mtcars}},
\code{\link{mlr_tasks_pima}},
\code{\link{mlr_tasks_sonar}},
\code{\link{mlr_tasks_spam}},
\code{\link{mlr_tasks_wine}},
\code{\link{mlr_tasks_zoo}}
}
\concept{Task}
