% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measure.R
\docType{data}
\name{Measure}
\alias{Measure}
\title{Measure Class}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the abstract base class for measures like \link{MeasureClassif} and \link{MeasureRegr}.

Measures are classes around tailored around two functions:
\enumerate{
\item A function \code{score} which quantifies the performance by comparing true and predicted response.
\item A function \code{aggregator} which combines multiple performance scores returned by
\code{calculate} to a single numeric value.
}

In addition to these two functions, meta-information about the performance measure is stored.

Predefined measures are stored in the \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} \link{mlr_measures},
e.g. \code{\link[=mlr_measures_classif.auc]{classif.auc}} or \code{\link[=mlr_measures_time_train]{time_train}}.
A guide on how to extend \CRANpkg{mlr3} with custom measures can be found in the \href{https://mlr3book.mlr-org.com}{mlr3book}.
}
\section{Construction}{

Note: This object is typically constructed via a derived classes, e.g. \link{MeasureClassif} or \link{MeasureRegr}.\preformatted{m = Measure$new(id, task_type = NA, range = c(-Inf, Inf), minimize = NA, aggregator = NULL, properties = character(), predict_type = "response",
    predict_sets = "test", task_properties = character(), packages = character(), man = NA_character_)
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier for the measure.
\item \code{task_type} :: \code{character(1)}\cr
Type of the task the measure can operator on. E.g., \code{"classif"} or \code{"regr"}.
\item \code{range} :: \code{numeric(2)}\cr
Feasible range for this measure as \code{c(lower_bound, upper_bound)}.
Both bounds may be infinite.
\item \code{minimize} :: \code{logical(1)}\cr
Set to \code{TRUE} if good predictions correspond to small values,
and to \code{FALSE} if good predictions correspond to large values.
If set to \code{NA} (default), tuning this measure is not possible.
\item \code{aggregator} :: \code{function(x)}\cr
Function to aggregate individual performance scores \code{x} where \code{x} is a numeric vector.
If \code{NULL}, defaults to \code{\link[=mean]{mean()}}.
\item \code{properties} :: \code{character()}\cr
Properties of the measure.
Must be a subset of \link[=mlr_reflections]{mlr_reflections$measure_properties}.
Supported by \code{mlr3}:
\itemize{
\item \code{"requires_task"} (requires the complete \link{Task}),
\item \code{"requires_learner"} (requires the trained \link{Learner}),
\item \code{"requires_train_set"} (requires the training indices from the \link{Resampling}), and
\item \code{"na_score"} (the measure is expected to occasionally return \code{NA}).
}
\item \code{predict_type} :: \code{character(1)}\cr
Required predict type of the \link{Learner}.
Possible values are stored in \link[=mlr_reflections]{mlr_reflections$learner_predict_types}.
\item \code{predict_sets} :: \code{character()}\cr
Prediction sets to operate on, used in \code{aggregate()} to extract the matching \code{predict_sets} from the \link{ResampleResult}.
Multiple predict sets are calculated by the respective \link{Learner} during \code{\link[=resample]{resample()}}/\code{\link[=benchmark]{benchmark()}}.
Must be a non-empty subset of \code{c("train", "test")}.
If multiple sets are provided, these are first combined to a single prediction object.
Default is \code{"test"}.
\item \code{task_properties} :: \code{character()}\cr
Required task properties, see \link{Task}.
\item \code{packages} :: \code{character()}\cr
Set of required packages.
Note that these packages will be loaded via \code{\link[=requireNamespace]{requireNamespace()}}, and are not attached.
\item \code{man} :: \code{character(1)}\cr
String in the format \code{[pkg]::[topic]} pointing to a manual page for this object.
}
}

\section{Fields}{

All variables passed to the constructor.
}

\section{Methods}{

\itemize{
\item \code{aggregate(rr)}\cr
\link{ResampleResult} -> \code{numeric(1)}\cr
Aggregates multiple performance scores into a single score using the \code{aggregator} function of the measure.
Operates on the \link{Prediction}s of \link{ResampleResult} with matching \code{predict_sets}.
\item \code{score(prediction, task = NULL, learner = NULL, train_set = NULL)}\cr
((named list of) \link{Prediction}, \link{Task}, \link{Learner}, \code{integer()} | \code{character()}) -> \code{numeric(1)}\cr
Takes a \link{Prediction} (or a list of \link{Prediction} objects named with valid \code{predict_sets})
and calculates a numeric score.
If the measure if flagged with the properties \code{"requires_task"}, \code{"requires_learner"} or \code{"requires_train_set"}, you must additionally
pass the respective \link{Task}, the trained \link{Learner} or the training set indices.
This is handled internally during \code{\link[=resample]{resample()}}/\code{\link[=benchmark]{benchmark()}}.
\item \code{help()}\cr
() -> \code{NULL}\cr
Opens the corresponding help page referenced by \code{$man}.
}
}

\seealso{
Other Measure: \code{\link{MeasureClassif}},
  \code{\link{MeasureRegr}}, \code{\link{mlr_measures}}
}
\concept{Measure}
\keyword{datasets}
