% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostSensTask.R
\name{makeCostSensTask}
\alias{makeCostSensTask}
\alias{CostSensTask}
\title{Create a cost-sensitive classification task.}
\usage{
makeCostSensTask(
  id = deparse(substitute(data)),
  data,
  costs,
  blocking = NULL,
  coordinates = NULL,
  fixup.data = "warn",
  check.data = TRUE
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Id string for object.
Default is the name of the R variable passed to \code{data}.}

\item{data}{(\link{data.frame})\cr
A data frame containing the features and target variable(s).}

\item{costs}{(\link{data.frame})\cr
A numeric matrix or data frame containing the costs of misclassification.
We assume the general case of observation specific costs.
This means we have n rows, corresponding to the observations, in the same order as \code{data}.
The columns correspond to classes and their names are the class labels
(if unnamed we use y1 to yk as labels).
Each entry (i,j) of the matrix specifies the cost of predicting class j
for observation i.}

\item{blocking}{(\link{factor})\cr
An optional factor of the same length as the number of observations.
Observations with the same blocking level \dQuote{belong together}.
Specifically, they are either put all in the training or the test set
during a resampling iteration.
Default is \code{NULL} which means no blocking.}

\item{coordinates}{(\link{data.frame})\cr
Coordinates of a spatial data set that will be used for spatial partitioning of the data in a spatial cross-validation resampling setting.
Coordinates have to be numeric values.
Provided \link{data.frame} needs to have the same number of rows as data and consist of at least two dimensions.}

\item{fixup.data}{(\code{character(1)})\cr
Should some basic cleaning up of data be performed?
Currently this means removing empty factor levels for the columns.
Possible choices are:
\dQuote{no} = Don't do it.
\dQuote{warn} = Do it but warn about it.
\dQuote{quiet} = Do it but keep silent.
Default is \dQuote{warn}.}

\item{check.data}{(\code{logical(1)})\cr
Should sanity of data be checked initially at task creation?
You should have good reasons to turn this off (one might be speed).
Default is \code{TRUE}.}
}
\description{
Create a cost-sensitive classification task.
}
\seealso{
\link{Task} \link{ClassifTask} \link{ClusterTask} \link{MultilabelTask} \link{RegrTask} \link{SurvTask}

Other costsens: 
\code{\link{makeCostSensClassifWrapper}()},
\code{\link{makeCostSensRegrWrapper}()},
\code{\link{makeCostSensWeightedPairsWrapper}()}
}
\concept{costsens}
