% Generated by roxygen2 (4.0.1): do not edit by hand
\name{predict.WrappedModel}
\alias{predict.WrappedModel}
\title{Predict new data.}
\usage{
\method{predict}{WrappedModel}(object, task, newdata, subset, ...)
}
\arguments{
\item{object}{[\code{\link{WrappedModel}}]\cr
Wrapped model, result of \code{\link{train}}.}

\item{task}{[\code{\link{SupervisedTask}}]\cr
The task. If this is passed, data from this task is predicted.}

\item{newdata}{[\code{data.frame}]\cr
New observations which should be predicted.
Pass this alternatively instead of \code{task}.}

\item{subset}{[\code{integer}]\cr
Index vector to subset \code{task} or \code{newdata}.
Default is all data.}

\item{...}{[any]\cr
Currently ignored.}
}
\value{
[\code{\link{Prediction}}].
}
\description{
Predict the target variable of new data using a fitted model.
What is stored exactly in the [\code{\link{Prediction}}] object depends
on the \code{predict.type} setting of the \code{\link{Learner}}.
If \code{predict.type} was set to \dQuote{prob} probability thresholding
can be done calling the \code{\link{setThreshold}} function on the
prediction object.
}
\examples{
# train and predict
train.set = seq(1, 150, 2)
test.set = seq(2, 150, 2)
model = train("classif.lda", iris.task, subset = train.set)
p = predict(model, newdata = iris, subset = test.set)
print(p)
predict(model, task = iris.task, subset = test.set)

# predict now probabiliies instead of class labels
lrn = makeLearner("classif.lda", predict.type = "prob")
model = train(lrn, iris.task, subset = train.set)
p = predict(model, task = iris.task, subset = test.set)
print(p)
getProbabilities(p)
}
\seealso{
Other predict: \code{\link{getProbabilities}};
  \code{\link{setPredictType}}
}

