% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_gcc.R
\encoding{UTF-8}
\name{dis_gcc}
\alias{dis_gcc}
\title{Constructs a pairwise distance matrix based on the generalized cross-correlation}
\usage{
dis_gcc(X, lag_max = 1, features = FALSE)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{lag_max}{The maximum lag considered to compute the generalized cross-correlation.}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{GCC}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{GCC}}.
}
\description{
\code{dis_gcc} returns a pairwise distance matrix based on the generalized
cross-correlation measure introduced by \insertCite{alonso2019clustering;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T} is defined
as
\deqn{d_{GCC}(\boldsymbol X_T, \boldsymbol Y_T)=\Bigg[\sum_{j_1,j_2=1, j_1 \ne j_2}^{d}
\bigg(GCC(\boldsymbol X_{T,j_1}, \boldsymbol X_{T,j_2} )-GCC(\boldsymbol Y_{T,j_1},\boldsymbol Y_{T,j_2})\bigg)^2\Bigg]^{1/2},}
where \eqn{\boldsymbol X_{T,j}} and \eqn{\boldsymbol Y_{T,j}} are the \eqn{j}th dimensions (univariate time series) of
\eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T}, respectively, and \eqn{GCC(\cdot, \cdot)} is the genelarized cross-correlation
measure between univariate series proposed by .
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_gcc(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_cor
feature_dataset <- dis_gcc(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{alonso2019clustering}{mlmts}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
