% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.r
\name{genotypes.boxplot}
\alias{genotypes.boxplot}
\title{Boxplots representation of the distributions of phenotypes according to allelic classes}
\usage{
genotypes.boxplot(X, Y, markers = "all", effects = NULL,
  genotypes = c("00", "01|10", "11"), tukeyTextCol = NA, tukeyTextCex = 1,
  tukeyCol = c("#2ecc71", "#3498db", "#9b59b6", "#6c7a89", "#f2ca27",
  "#e67e22", "#e74c3c", "#c08d57"), tukeyPch = c(1, 3, 2, 4:8),
  tukeyCex = 1, ...)
}
\arguments{
\item{X}{A matrix where rownames are individuals names, colnames are markers names, and values are genotypes. Genotypes are encoded as allelic dosage (0, 1, 2) or as any numeric values     as long as the smallest and highest values correspond to homozygous and the mean of these smallest and highest values to heterozygous. Other values (imputated genotypes) will be rounded to the nearest.}

\item{Y}{A numeric named vector where the names are individuals names and the values their phenotype. The names of Y will be matched to the row names of X.}

\item{markers}{A vector of names of markers, a plot will be drawn for each of them. "all" is a special value meaning a plot will be drawn for all markers in the estimations object, or in the matrix X if the estimations object is not provided.}

\item{effects}{A GWAS.EFFECTS oject, created with \code{Estimation_allmodels} function.}

\item{genotypes}{A length 3 string vector, used as labels for the genotypes.}

\item{tukeyTextCol}{Colors of the letters of the Tukey classes.}

\item{tukeyTextCex}{Size of the letters of the Tukey classes.}

\item{tukeyCol}{Color of the symbols of the Tukey classes.}

\item{tukeyPch}{Symbols of the Tukey classes.}

\item{tukeyCex}{Size of the symbols of the Tukey classes.}

\item{...}{Additional arguments are passed to the \code{boxplot} function.}
}
\description{
For each allele class of a given loci, display as boxplot the distributions of the phenotypes of individuals with this allele class.

For instance, it can be used as a simple representation of the effects of one QTL.
}
\details{
A plot is drawn for each of marker of the markers vector.

 In each of thes plots, a boxplot is drawn for each allelic classes. Theses boxplots represent the distribution of the phenotypes of individuals with these allelic classes.

 If the effects parameter is not NULL, the Tukey classes of the effects of markers will be represented as a symbol and/or a letter in the boxplot. The ordinates of these symbols is the average of the phenotype of individuals with the allele.
}
\examples{
### Additive model ###
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa)
KK = list(K.add)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))

# Effects estimations with the selected model
sel_XXclass <- fromeBICtoEstimation(XX, res.eBIC)
eff.estimations <- Estimation_allmodels(floweringDateAD, sel_XXclass, KK)
genotypes.boxplot(Xa, floweringDateAD, effects = eff.estimations)
}
}
