% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-runs.R
\name{mlflow_log_batch}
\alias{mlflow_log_batch}
\title{Log Batch}
\usage{
mlflow_log_batch(
  metrics = NULL,
  params = NULL,
  tags = NULL,
  run_id = NULL,
  client = NULL
)
}
\arguments{
\item{metrics}{A dataframe of metrics to log, containing the following columns: "key", "value",
"step", "timestamp". This dataframe cannot contain any missing ('NA') entries.}

\item{params}{A dataframe of params to log, containing the following columns: "key", "value".
This dataframe cannot contain any missing ('NA') entries.}

\item{tags}{A dataframe of tags to log, containing the following columns: "key", "value".
This dataframe cannot contain any missing ('NA') entries.}

\item{run_id}{Run ID.}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}
}
\description{
Log a batch of metrics, params, and/or tags for a run. The server will respond with an error (non-200 status code)
  if any data failed to be persisted. In case of error (due to internal server error or an invalid request), partial
  data may be written.
}
