% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get.mldr}
\alias{get.mldr}
\title{Get a multilabel dataset by name}
\usage{
get.mldr(name, download.dir = if (is.null(getOption("mldr.download.dir")))
  file.path(normalizePath("~"), ".mldr", "datasets") else
  getOption("mldr.download.dir"))
}
\arguments{
\item{name}{Name of the dataset to load}

\item{download.dir}{The path to the download directory, can be also set through \code{options()}}
}
\description{
\code{get.mldr} obtains a multilabel dataset, either by finding it inside the package data, in the download directory or by downloading it.
}
\examples{
\dontrun{
library(mldr.datasets)
# customize the download directory
options(mldr.download.dir = "./datasets")
# retrieve the bibtex dataset, as an mldr object, into a variable
bibtex <- get.mldr("bibtex")
bibtex$measures
}
}
