% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setFishing.R
\name{gear_params}
\alias{gear_params}
\alias{gear_params<-}
\title{Gear parameters}
\usage{
gear_params(params)

gear_params(params) <- value
}
\arguments{
\item{params}{A MizerParams object}

\item{value}{A data frame with the gear parameters.}
}
\value{
Data frame with gear parameters
}
\description{
These functions allow you to get or set the gear parameters stored in
a MizerParams object. These are used by \code{\link[=setFishing]{setFishing()}} to set up the
selectivity and catchability and thus together with the fishing effort
determine the fishing mortality.
}
\details{
The \code{gear_params} data has one row for each gear-species pair and one
column for each parameter that determines how that gear interacts with that
species. The columns are:
\itemize{
\item \code{species} The name of the species
\item \code{gear} The name of the gear
\item \code{catchability} A number specifying how strongly this gear selects this
species.
\item \code{sel_func} The name of the function that calculates the selectivity curve.
\item One column for each selectivity parameter needed by the selectivity
functions.
}

For the details see \code{\link[=setFishing]{setFishing()}}.

The fishing effort, which is also needed to determine the fishing mortality
exerted by a gear is not set via the \code{gear_params} data frame but is set
with \code{initial_effort()} or is specified when calling \code{project()}.

If you change a gear parameter, this will be used to recalculate the
\code{selectivity} and \code{catchability} arrays by calling \code{\link[=setFishing]{setFishing()}},
unless you have previously set these by hand.

\verb{gear_params<-} automatically sets the row names to contain the species name
and the gear name, separated by a comma and a space. The last example below
illustrates how this facilitates changing an individual gear parameter.
}
\examples{
params <- NS_params

# gears set up in example
gear_params(params)

# setting totally different gears
gear_params(params) <- data.frame(
    gear = c("gear1", "gear2", "gear1"),
    species = c("Cod", "Cod", "Haddock"),
    catchability = c(0.5, 2, 1),
    sel_fun = c("sigmoid_weight", "knife_edge", "sigmoid_weight"),
    sigmoidal_weight = c(1000, NA, 800),
    sigmoidal_sigma = c(100, NA, 100),
    knife_edge_size = c(NA, 1000, NA)
    )
gear_params(params)

# changing an individual entry
gear_params(params)["Cod, gear1", "catchability"] <- 0.8
}
\seealso{
\code{\link[=validGearParams]{validGearParams()}}

Other functions for setting parameters: 
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
