% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setResource.R
\name{resource_params}
\alias{resource_params}
\alias{resource_params<-}
\title{Resource parameters}
\usage{
resource_params(params)

resource_params(params) <- value
}
\arguments{
\item{params}{A MizerParams object}

\item{value}{A named list of resource parameters.}
}
\description{
These functions allow you to get or set the resource parameters stored in a
MizerParams object. The resource parameters are stored as a named list with
the slot names \code{r_pp}, \code{kappa}, \code{lambda}, \code{n}, \code{w_pp_cutoff}. For their
meaning see Details below. If you change these parameters then this will
recalculate the resource rate and the resource capacity, unless you have set
custom values for these. If you have specified a different resource dynamics
function that requires additional parameters, then these should also be added
to the \code{resource_params} list.
}
\details{
The resource parameters \code{r_pp} and \code{n} are used to set the intrinsic
replenishment rate \eqn{r_R(w)} for the resource at size \eqn{w} to
\deqn{r_R(w) = r_{pp}\, w^{n-1}.}{r_R(w) = r_pp w^{n-1}}

The resource parameters \code{kappa}, \code{lambda} and \code{w_pp_cutoff} are used to set
the intrinsic resource carrying capacity capacity \eqn{c_R(w)} at size \eqn{w}
is set to
\deqn{c_R(w) = \kappa\, w^{-\lambda}}{c_R(w) = \kappa w^{-\lambda}}
for all \eqn{w} less than \code{w_pp_cutoff} and zero for larger sizes.

If you use the default semichemostat dynamics for the resource then these
rates enter the equation for the resource abundance density as
\deqn{\frac{\partial N_R(w,t)}{\partial t} = r_R(w) \Big[ c_R (w) - N_R(w,t) \Big] - \mu_R(w, t) N_R(w,t)}{dN_R(w,t)/d t  = r_R(w) ( c_R (w) - N_R(w,t) ) - \mu_R(w,t ) N_R(w,t)}
where the mortality \eqn{\mu_R(w, t)} is
due to predation by consumers and is calculate with \code{\link[=getResourceMort]{getResourceMort()}}.

You can however set up different resource dynamics with
\code{\link[=resource_dynamics<-]{resource_dynamics<-()}}.
}
\examples{
resource_params(NS_params)
# Doubling the replenishment rate
params <- NS_params
resource_params(params)$r_pp <- 2 * resource_params(params)$r_pp
}
\seealso{
Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setResource}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
