% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setInitialValues.R
\name{setInitialValues}
\alias{setInitialValues}
\title{Set initial values to final values of a simulation}
\usage{
setInitialValues(params, sim)
}
\arguments{
\item{params}{A \code{\link[=MizerParams]{MizerParams()}} object}

\item{sim}{A \code{MizerSim} object.}
}
\value{
The \code{params} object with updated initial values and initial effort,
taken from the
values at the final time of the simulation in \code{sim}. Because of the way the
R language works, \code{setInitialValues()} does not make the changes to the
params object that you pass to it but instead returns a new params object.
So to affect the change you call the function in the form
\code{params <- setInitialValues(params, sim)}.
}
\description{
Takes the final values from a simulation in a MizerSim object and stores them
as initial values in a MizerParams object.
}
\examples{
\dontrun{
params <- NS_params
sim <- project(params, t_max = 20, effort = 0.5)
params <- setInitialValues(params, sim)
}
}
\seealso{
Other functions for setting parameters: 
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setResource}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
