% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotM2}
\alias{plotM2}
\title{Alias for plotPredMort}
\usage{
plotM2(object, species = NULL, time_range, highlight = NULL, ...)
}
\arguments{
\item{object}{An object of class \linkS4class{MizerSim} or \linkS4class{MizerParams}.}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{time_range}{The time range (either a vector of values, a vector of min
and max time, or a single value) to average the abundances over. Default is
the final time step. Ignored when called with a \linkS4class{MizerParams}
object.}

\item{highlight}{Name or vector of names of the species to be highlighted.}

\item{...}{Other arguments (currently unused)}
}
\value{
A plot
}
\description{
An alias provided for backward compatibility with mizer version <= 1.0
}
\examples{
\donttest{
params <- suppressMessages(newMultispeciesParams(NS_species_params_gears, inter))
sim <- project(params, effort=1, t_max=20, t_save = 2, progress_bar = FALSE)
plotPredMort(sim)
plotPredMort(sim, time_range = 10:20)
}
}
\seealso{
\code{\link[=plotting_functions]{plotting_functions()}},  \code{\link[=getPredMort]{getPredMort()}}

Other plotting functions: 
\code{\link{plot,MizerSim,missing-method}},
\code{\link{plotBiomass}()},
\code{\link{plotDiet}()},
\code{\link{plotFMort}()},
\code{\link{plotFeedingLevel}()},
\code{\link{plotGrowthCurves}()},
\code{\link{plotSpectra}()},
\code{\link{plotYieldGear}()},
\code{\link{plotYield}()},
\code{\link{plotting_functions}}
}
