% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{summary_functions}
\alias{summary_functions}
\title{Description of summary functions}
\description{
Mizer provides a range of functions to summarise the results of a simulation.
}
\details{
A list of available summary functions is given in the table below.
\tabular{lll}{
Function \tab Returns \tab Description \cr
\code{\link[=getDiet]{getDiet()}} \tab Three dimensional array (predator x size x prey) \tab Diet of predator at size, resolved by prey species \cr
\code{\link[=getSSB]{getSSB()}} \tab Two dimensional array (time x species) \tab Total Spawning Stock Biomass (SSB) of each species through time where SSB is calculated as the sum of weight of all mature individuals. \cr
\code{\link[=getBiomass]{getBiomass()}} \tab Two dimensional array (time x species) \tab Total biomass of each species through time. \cr
\code{\link[=getN]{getN()}} \tab Two dimensional array (time x species) \tab Total abundance of each species through time. \cr
\code{\link[=getFeedingLevel]{getFeedingLevel()}} \tab Three dimensional array (time x species x size) \tab Feeding level of each species by size through time. \cr
\code{\link{getM2}} \tab Three dimensional array (time x species x size) \tab The predation mortality imposed on each species by size through time. \cr
\code{\link[=getFMort]{getFMort()}} \tab Three dimensional array (time x species x size) \tab Total fishing mortality on each species by size through time. \cr
\code{\link[=getFMortGear]{getFMortGear()}} \tab Four dimensional array (time x gear x species x size) \tab Fishing mortality on each species by each gear at size through time. \cr
\code{\link[=getYieldGear]{getYieldGear()}} \tab Three dimensional array (time x gear x species) \tab Total yield by gear and species through time. \cr
\code{\link[=getYield]{getYield()}} \tab Two dimensional array (time x species) \tab Total yield of each species across all gears through time. \cr
}
}
\seealso{
\code{\link[=indicator_functions]{indicator_functions()}}, \code{\link[=plotting_functions]{plotting_functions()}}
}
