% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\docType{methods}
\name{getPredRate}
\alias{getPredRate}
\alias{getPredRate,MizerParams,matrix,numeric,matrix-method}
\alias{getPredRate,MizerParams,matrix,numeric,missing-method}
\title{Get predation rate}
\usage{
getPredRate(object, n, n_pp, feeding_level)

\S4method{getPredRate}{MizerParams,matrix,numeric,matrix}(object, n, n_pp,
  feeding_level)

\S4method{getPredRate}{MizerParams,matrix,numeric,missing}(object, n, n_pp)
}
\arguments{
\item{object}{A \code{MizerParams} object.}

\item{n}{A matrix of species abundance (species x size).}

\item{n_pp}{A vector of the background abundance by size.}

\item{feeding_level}{The current feeding level (optional). A matrix of size
no. species x no. size bins. If not supplied, is calculated internally
using the \code{getFeedingLevel()} method.}
}
\value{
A two dimensional array (predator species x prey size), 
  where the prey size runs over community plus background spectrum.
}
\description{
Calculates the predation rate of each predator species at size on prey size. 
In formulas \deqn{\int\phi_i(w_p/w) (1-f_i(w)) \gamma_i w^q N_i(w) dw}
This method is used by the \code{\link{project}} method for performing
simulations. In the simulations, it is combined with the interaction matrix
(see \code{\link{MizerParams}}) to calculate the realised predation mortality
(see \code{\link{getM2}}).

\code{getPredRate} method with \code{feeding_level} argument.

\code{getPredRate} method without \code{feeding_level} argument.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the feeding level at one time step
n <- sim@n[21,,]
n_pp <- sim@n_pp[21,]
getPredRate(params,n,n_pp)
}
}
\seealso{
\code{\link{project}}, \code{\link{getM2}}, \code{\link{getFeedingLevel}} and \code{\link{MizerParams}}
}
