% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MizerSim-class.R
\docType{methods}
\name{MizerSim}
\alias{MizerSim}
\alias{MizerSim,MizerParams-method}
\title{Constructor for the \code{MizerSim} class}
\usage{
MizerSim(object, ...)

\S4method{MizerSim}{MizerParams}(object, t_dimnames = NA, t_max = 100,
  t_save = 1)
}
\arguments{
\item{object}{a \linkS4class{MizerParams} object}

\item{...}{Other arguments (currently not used).}

\item{t_dimnames}{Numeric vector that is used for the time dimensions of the
slots. Default = NA.}

\item{t_max}{The maximum time step of the simulation. Only used if t_dimnames
= NA. Default value = 100.}

\item{t_save}{How often should the results of the simulation be stored. Only
used if t_dimnames = NA. Default value = 1.}
}
\value{
An object of type \linkS4class{MizerSim}
}
\description{
A constructor for the \code{MizerSim} class. This is used by the
\code{project} method to create \code{MizerSim} objects of the right
dimensions. It is not necessary for users to use this constructor.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params)
}
}
\seealso{
\code{\link{project}} \linkS4class{MizerParams}
  \linkS4class{MizerSim}
}
