% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node_vlmc.R
\name{metrics.ctx_node}
\alias{metrics.ctx_node}
\title{Predictive quality metrics for a node of a context tree}
\usage{
\method{metrics}{ctx_node}(model, ...)
}
\arguments{
\item{model}{T \code{ctx_node} object as returned by \code{\link[=find_sequence]{find_sequence()}}.}

\item{...}{Additional parameters for predictive metrics computation.}
}
\value{
The returned value is guaranteed to have at least three components
\itemize{
\item \code{accuracy}: the accuracy of the predictions
\item \code{conf_mat}: the confusion matrix of the predictions, with predicted values
in rows and true values in columns
\item \code{auc}: the AUC of the predictive model
}
}
\description{
This function computes and returns predictive quality metrics for a node
(\code{ctx_node}) extracted from a context tree.
}
\details{
Compared to \code{\link[=metrics.vlmc]{metrics.vlmc()}}, this function focuses on a single context and
assesses the quality of its predictions, disregarding observations that have
other contexts. Apart from this limited scope, the function operates as
\code{\link[=metrics.vlmc]{metrics.vlmc()}}.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
model <- vlmc(dts)
model_ctxs <- contexts(model)
metrics(model_ctxs[[4]])
}
\references{
David J. Hand and Robert J. Till (2001). "A Simple Generalisation
of the Area Under the ROC Curve for Multiple Class Classification Problems."
\emph{Machine Learning} 45(2), p. 171--186. DOI: \doi{10.1023/A:1010920819831}.
}
\seealso{
\code{\link[=metrics.vlmc]{metrics.vlmc()}}, \code{\link[=metrics.ctx_node]{metrics.ctx_node()}}, \code{\link[=contexts.vlmc]{contexts.vlmc()}}, \code{\link[=predict.vlmc]{predict.vlmc()}}.
}
