% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc.R
\name{cutoff.covlmc}
\alias{cutoff.covlmc}
\title{Cut off values for pruning the context tree of a VLMC with covariates}
\usage{
\method{cutoff}{covlmc}(model, raw = FALSE, tolerance = .Machine$double.eps^0.5, ...)
}
\arguments{
\item{model}{a fitted COVLMC model.}

\item{raw}{specify whether the returned values should be limit values
computed in the model or modified values that guarantee pruning (see
details)}

\item{tolerance}{specify the minimum separation between two consecutive
values of the cut off in native mode (before any transformation). See
details.}

\item{...}{additional arguments for the \code{cutoff} function.}
}
\value{
a vector of cut off values, \code{NULL} if none can be computed
}
\description{
This function returns all the cut off values that should induce a pruning of
the context tree of a VLMC with covariates.
}
\details{
Notice that the list of cut off values returned by the function is not as
complete as the one computed for a VLMC without covariates. Indeed, pruning
the COVLMC tree creates new pruning opportunities that are not evaluated
during the construction of the initial model, while all pruning opportunities
are computed during the construction of a VLMC context tree. Nevertheless,
the largest value returned by the function is guaranteed to produce the least
pruned tree consistent with the reference one.

For large COVLMC, some cut off values can be almost identical, with a
difference of the order of the machine epsilon value. The \code{tolerance}
parameter is used to keep only values that are different enough. This is done
in the quantile scale, before transformations implemented when \code{raw} is
\code{FALSE}.

Notice that the loglikelihood scale is not directly useful in COVLMC as the
differences in model sizes are not constant through the pruning process. As a
consequence, this function does not provide \code{mode} parameter, contrarily to
\code{\link[=cutoff.vlmc]{cutoff.vlmc()}}.

Setting \code{raw} to \code{TRUE} removes the small perturbation that are subtracted
from the log-likelihood ratio values computed from the COVLMC (in quantile
scale).

As automated model selection is provided by \code{\link[=tune_covlmc]{tune_covlmc()}}, the direct use of
\code{cutoff} should be reserved to advanced exploration of the set of trees that
can be obtained from a complex one, e.g. to implement model selection
techniques that are not provided by \code{\link[=tune_covlmc]{tune_covlmc()}}.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
m_nocovariate <- vlmc(dts)
draw(m_nocovariate)
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5)
draw(m_cov)
cutoff(m_cov)
}
