% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KendallCCA.R
\name{lambdaseq_generate}
\alias{lambdaseq_generate}
\title{Internal data-driven lambda sequence generating function.}
\usage{
lambdaseq_generate(
  nlamseq = 20,
  lam.eps = 0.01,
  Sigma1,
  Sigma2,
  Sigma12,
  w1init = NULL,
  w2init = NULL
)
}
\arguments{
\item{nlamseq}{The length of lambda sequence}

\item{lam.eps}{The smallest value for lambda as a fraction of maximum lambda value}

\item{Sigma1}{Covariance/correlation matrix of \eqn{X1} (p1 by p1)}

\item{Sigma2}{Covariance/correlation matrix of \eqn{X2} (p2 by p2)}

\item{Sigma12}{Covariance/correlation matrix betweem \eqn{X1} and \eqn{X2}}

\item{w1init}{Initial value for canonical vector \eqn{w1}}

\item{w2init}{Initial value for canonical vector \eqn{w2}}
}
\value{
\code{lambdaseq_generate} returns a list of length 2. Each vector is of the same length \code{nlamseq} and will be used for each data set separately.
}
\description{
This internal function generates lambda sequence of length \code{nlamseq} equally spaced on a logarithmic scale. Since this is for sparse CCA, it returns a list of two vectors. Each vector will be used for each data set \eqn{X1} and \eqn{X2}. And \eqn{w1} and \eqn{w2} denote canonical vector for each data set.
}
