% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reinstate.R
\name{reinstate}
\alias{reinstate}
\title{Reinstate the Binned Data to the Raw Data}
\usage{
reinstate(data)
}
\arguments{
\item{data}{a three-column matrix representing the raw data}
}
\value{
The function returns a numeric vector.
}
\description{
This function creates a numeric vector approximating the raw data from binned data
}
\details{
The function \code{reinstate} creates a numeric vector by generating \eqn{n_i}
random data from the Uniform distribution \eqn{U(a_i, b_i)} for \eqn{i = 1, \dots, r}
and then combine all random data together. \eqn{a_i, b_i, n_i}
are the first, second and the third column of the matrix \code{data}
and \eqn{r} is the number of bins.
It is used for enabling parameter initialization for EM algorithm when we fit mixture
models for binned data.
}
\examples{
x <- rnorm(100)
data <- bin(x, seq(-3, 3, 0.25))
y <- reinstate(data)

}
\seealso{
\code{\link{bin}}
}
