% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.prop.R
\name{ci.prop}
\alias{ci.prop}
\title{Confidence Interval for Proportions}
\usage{
ci.prop(..., data = NULL, method = c("wald", "wilson"),
        alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
        group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE,
        digits = 3, as.na = NULL, write = NULL, append = TRUE, check = TRUE,
        output = TRUE)
}
\arguments{
\item{...}{a numeric vector, matrix or data frame with numeric variables
with 0 and 1 values, i.e., factors and character variables
are excluded from \code{x} before conducting the analysis.
Alternatively, an expression indicating the variable
names in \code{data} e.g., \code{ci.prop(x1, x2, x3, data = dat)}.
Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{data}{a data frame when specifying one or more variables in the
argument \code{...}. Note that the argument is \code{NULL}
when specifying a numeric vector, matrix or data frame
for the argument \code{...}.}

\item{method}{a character string specifying the method for computing the confidence interval,
must be one of \code{"wald"}, or \code{"wilson"} (default).}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}

\item{group}{either a character string indicating the variable name of
the grouping variable in \code{...} or \code{data}, or a vector
representing the grouping variable.}

\item{split}{either a character string indicating the variable name of
the split variable in \code{...} or \code{data}, or a vector
representing the split variable.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before conducting the analysis
(i.e., listwise deletion) when specifying more than one outcome variable.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to \code{x}, but
not to \code{group} or \code{split}.}

\item{write}{a character string naming a text file with file extension
\code{".txt"} (e.g., \code{"Output.txt"}) for writing the
output into a text file.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{list with the input specified in \code{...}, \code{data},                           \code{group}, and \code{split}}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{result table}
}
\description{
This function computes a confidence interval for proportions for one or more variables, optionally
by a grouping and/or split variable.
}
\details{
The Wald confidence interval which is based on the normal approximation to the binomial distribution are
computed by specifying \code{method = "wald"}, while the Wilson (1927) confidence interval (aka Wilson
score interval) is requested by specifying \code{method = "wilson"}. By default, Wilson confidence
interval is computed which have been shown to be reliable in small samples of n = 40 or less, and
larger samples of n > 40 (Brown, Cai & DasGupta, 2001), while the Wald confidence intervals is
inadequate in small samples and when \emph{p} is near 0 or 1 (Agresti & Coull, 1998).
}
\examples{
# Example 1a: Two-Sided 95% CI for 'vs'
ci.prop(mtcars$vs)
#
# Example 1b: Alternative specification using the 'data' argument
ci.prop(vs, data = mtcars)

# Example 2: Two-Sided 95% CI using Wald method
ci.prop(mtcars$vs, method = "wald")

# Example 3: One-Sided 95% CI
ci.prop(mtcars$vs, alternative = "less")

# Example 4: Two-Sided 99% CI
ci.prop(mtcars$vs, conf.level = 0.99)

# Example 5: Two-Sided 95% CI, print results with 4 digits
ci.prop(mtcars$vs, digits = 4)

# Example 6a: Two-Sided 95% CI for 'vs' and 'am',
# listwise deletion for missing data
ci.prop(mtcars[, c("vs", "am")], na.omit = TRUE)

# Example 6b: Alternative specification using the 'data' argument
# listwise deletion for missing data
ci.prop(vs, am, data = mtcars, na.omit = TRUE)

# Example 7a: Two-Sided 95% CI, analysis by 'gear' separately
ci.prop(mtcars[, c("vs", "am")], group = mtcars$gear)

# Example 7b: Alternative specification using the 'data' argument
ci.prop(vs, am, data = mtcars, group = "gear")

# Example 8: Two-Sided 95% CI, analysis by 'gear' separately, sort by variables
ci.prop(mtcars[, c("vs", "am")], group = mtcars$gear, sort.var = TRUE)

# Example 9: Two-Sided 95% CI, split analysis by 'cyl'
ci.prop(mtcars[, c("vs", "am")], split = mtcars$cyl)

# Example 10a: Two-Sided 95% CI, analysis by 'gear' separately, split by 'cyl'
ci.prop(mtcars[, c("vs", "am")], group = mtcars$gear, split = mtcars$cyl)

# Example 10b: Alternative specification using the 'data' argument
ci.prop(vs, am, data = mtcars, group = "gear", split = "cyl")

\dontrun{
# Example 11: Write results into a text file
ci.prop(vs, am, data = mtcars, group = "gear", split = "cyl", write = "Prop.txt")
}
}
\references{
Agresti, A. & Coull, B.A. (1998). Approximate is better than "exact" for interval estimation of binomial
proportions. \emph{American Statistician, 52}, 119-126.

Brown, L. D., Cai, T. T., & DasGupta, A., (2001). Interval estimation for a binomial proportion.
\emph{Statistical Science, 16}, 101-133.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.

Wilson, E. B. (1927). Probable inference, the law of succession, and statistical inference.
\emph{Journal of the American Statistical Association, 22}, 209-212.
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}},
\code{\link{ci.prop.diff}}, \code{\link{ci.var}}, \code{\link{ci.sd}},
\code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
