% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov.b.R
\name{aov.b}
\alias{aov.b}
\title{Between-Subject Analysis of Variance}
\usage{
aov.b(formula, data, posthoc = TRUE, conf.level = 0.95, hypo = TRUE,
      descript = TRUE, effsize = FALSE, weighted = FALSE, correct = FALSE,
      plot = FALSE, point.size = 4, error.width = 0.1, xlab = NULL, ylab = NULL,
      ylim = NULL, breaks = ggplot2::waiver(), jitter = TRUE,
      jitter.size = 1.25, jitter.width = 0.05, jitter.alpha = 0.1,
      title = "",  subtitle = "Confidence Interval",
      digits = 2, p.digits = 4, as.na = NULL, check = TRUE,
      output = TRUE, ...)
}
\arguments{
\item{formula}{a formula of the form \code{y ~ group} where \code{y} is a numeric variable
giving the data values and \code{group} a numeric variable, character variable
or factor with more than two values or factor levels giving the corresponding groups.}

\item{data}{a matrix or data frame containing the variables in the formula \code{formula}.}

\item{posthoc}{logical: if \code{TRUE}, Tukey HSD post hoc test for multiple comparison is conducted.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval
for Cohen's d. Note that this argument is only used when conducting Welch's two-sample t-test.}

\item{hypo}{logical: if \code{TRUE}, null and alternative hypothesis are shown on the console.}

\item{descript}{logical: if \code{TRUE}, descriptive statistics are shown on the console.}

\item{effsize}{logical: if \code{TRUE}, effect size measure Cohen's d for Welch's two-sample t-test
(see \code{\link{cohens.d}}), \eqn{\eta^2} and \eqn{\omega^2} for the ANOVA and Cohen's d for the post
hoc tests are shown on the console..}

\item{weighted}{logical: if \code{TRUE}, the weighted pooled standard deviation is used to compute Cohen's d.}

\item{correct}{logical: if \code{TRUE}, correction factor to remove positive bias in small samples is used.}

\item{plot}{logical: if \code{TRUE}, a plot showing error bars for confidence intervals is drawn.}

\item{point.size}{a numeric value indicating the \code{size} aesthetic for the point representing the mean value.}

\item{error.width}{ a numeric value indicating the horizontal bar width of the error bar.}

\item{xlab}{a character string specifying the labels for the x-axis.}

\item{ylab}{a character string specifying the labels for the y-axis.}

\item{ylim}{a numeric vector of length two specifying limits of the limits of the y-axis.}

\item{breaks}{a numeric vector specifying the points at which tick-marks are drawn at the y-axis.}

\item{jitter}{logical: if \code{TRUE} (default), jittered data points are drawn.}

\item{jitter.size}{ a numeric value indicating the \code{size} aesthetic for the jittered data points.}

\item{jitter.width}{a numeric value indicating the amount of vertical and horizontal jitter.}

\item{jitter.alpha}{a numeric value indicating the opacity of the jittered data points.}

\item{title}{a character string specifying the text for the title for the plot.}

\item{subtitle}{a character string specifying the text for the subtitle for the plot.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
descriptive statistics and confidence interval.}

\item{p.digits}{an integer value indicating the number of decimal places to be used for displaying
the \emph{p}-value.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, list with the input specified in \code{x}
(\code{data}), specification of function arguments (\code{args}), and result table(s) (\code{result}).
}
\description{
This function performs an one-way between-subject analysis of variance (ANOVA)
including Tukey HSD post hoc test for multiple comparison and provides descriptive
statistics, effect size measures, and a plot showing error bars for confidence
intervals with jittered data points.
}
\details{
Note that by default Tukey HSD post hoc test reports Cohen's d based on the
weighted standard deviation (i.e., \code{weighted = TRUE}) when requesting an
effect size measure  (i.e., \code{effsize = TRUE}) following the recommendation
by Delacre et al. (2021).
}
\examples{
dat <- data.frame(group = c(1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3),
                  y = c(3, 1, 4, 2, 5, 3, 2, 3, 6, 6, 3, NA))

# Between-subject ANOVA
aov.b(y ~ group, data = dat)

# Between-subject ANOVA
# print effect size measures
aov.b(y ~ group, data = dat, effsize = TRUE)

# Between-subject ANOVA
# do not print hypotheses and descriptive statistics,
aov.b(y ~ group, data = dat, descript = FALSE, hypo = FALSE)

\dontrun{
# Between-subject ANOVA
# plot results
aov.b(y ~ group, data = dat, plot = TRUE)

# Load ggplot2 package
library(ggplot2)

# Save plot, ggsave() from the ggplot2 package
ggsave("Between-Subject_ANOVA.png", dpi = 600, width = 4.5, height = 6)

# Between-subject ANOVA
# extract plot
p <- aov.b(y ~ group, data = dat, output = FALSE)$plot
p

# Extract data
plotdat <- aov.b(y ~ group, data = dat,, output = FALSE)$data

# Draw plot in line with the default setting of aov.b()
ggplot(plotdat, aes(group, y)) +
  geom_point(stat = "summary", fun = "mean", size = 4) +
  stat_summary(fun.data = "mean_cl_normal", geom = "errorbar", width = 0.20) +
  scale_x_discrete(name = NULL) +
  labs(subtitle = "Two-Sided 95% Confidence Interval") +
  theme_bw() + theme(plot.subtitle = element_text(hjust = 0.5))
}
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.

Delacre, M., Lakens, D., Ley, C., Liu, L., & Leys, C. (2021). Why Hedges' g*s based on the non-pooled
standard deviation should be reported with Welch's t-test. https://doi.org/10.31234/osf.io/tu6mp
}
\seealso{
\code{\link{test.t}}, \code{\link{test.z}}, \code{\link{test.levene}}, \code{\link{test.welch}},
\code{\link{cohens.d}}, \code{\link{ci.mean.diff}}, \code{\link{ci.mean}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
