% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.trim.R
\name{chr.trim}
\alias{chr.trim}
\title{Trim Whitespace from String}
\usage{
chr.trim(x, side = c("both", "left", "right"), check = TRUE)
}
\arguments{
\item{x}{a character vector.}

\item{side}{a character string indicating the side on which to remove whitespace,
i.e., \code{"both"} (default), \code{"left"} or \code{"right"}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a character vector with whitespaces removed from the vector specified in \code{x}.
}
\description{
This function removes whitespace from start and/or end of a string
}
\note{
This function is based on the \code{str_trim()} function from the \pkg{stringr} package by Hadley Wickham.
}
\examples{
x <- "  string  "

# Remove whitespace at both sides
chr.trim(x)

# Remove whitespace at the left side
chr.trim(x, side = "left")

# Remove whitespace at the right side
chr.trim(x, side = "right")
}
\references{
Wickham, H. (2019). \emph{stringr: Simple, consistent wrappers for common string operations}.
R package version 1.4.0. \url{https://CRAN.R-project.org/package=stringr}
}
\seealso{
\code{\link{chr.gsub}}, \code{\link{chr.omit}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
