% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.z.R
\name{test.z}
\alias{test.z}
\alias{test.z.default}
\alias{test.z.formula}
\title{z-Test}
\usage{
test.z(x, ...)

\method{test.z}{default}(x, y = NULL, sigma = NULL, sigma2 = NULL, mu = 0,
       paired = FALSE, alternative = c("two.sided", "less", "greater"),
       hypo = TRUE, descript = TRUE, effsize = FALSE, digits = 2, p.digits = 4,
       as.na = NULL, check = TRUE, output = TRUE, ...)

\method{test.z}{formula}(formula, data, sigma = NULL, sigma2 = NULL,
       alternative = c("two.sided", "less", "greater"), hypo = TRUE,
       descript = TRUE, effsize = FALSE, digits = 2, p.digits = 4,
       as.na = NULL, check = TRUE, output = TRUE, ...)

}
\arguments{
\item{x}{a numeric vector of data values.}
\item{y}{a numeric vector of data values.}
\item{sigma}{a numeric vector indicating the population standard deviation(s). In case of two-sample z-test, equal standard deviations are assumed when specifying one value for the argument \code{sigma}; when specifying two values for the argument \code{sigma}, unequal standard deviations are assumed. Note that either argument \code{sigma} or argument \code{sigma2} is specified.}
\item{sigma2}{a numeric vector indicating the population variance(s). In case of two-sample z-test, equal variances are assumed when specifying one value for the argument \code{sigma2}; when specifying two values for the argument \code{sigma}, unequal variance are assumed. Note that either argument \code{sigma} or argument \code{sigma2} is specified.}
\item{mu}{a numeric value indicating the population mean under the null hypothesis. Note that the argument \code{mu} is only used when computing a one-sample z-test.}
\item{paired}{logical: if \code{TRUE}, paired-sample z-test is computed.}
\item{alternative}{a character string specifying the alternative hypothesis, must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}
\item{hypo}{logical: if \code{TRUE}, null and alternative hypothesis are shown on the console.}
\item{descript}{logical: if \code{TRUE}, descriptive statistics are shown on the console.}
\item{effsize}{logical: if \code{TRUE}, effect size measure Cohen's d is shown on the console.}
\item{digits}{an integer value indicating the number of decimal places to be used for displaying descriptive statistics and confidence interval.}
\item{p.digits}{an integer value indicating the number of decimal places to be used for displaying the \emph{p}-value.}
\item{as.na}{a numeric vector indicating user-defined missing values, i.e. these values are converted to \code{NA} before conducting the analysis.}
\item{check}{logical: if \code{TRUE}, argument specification is checked.}
\item{output}{logical: if \code{TRUE}, output is shown on the console.}
\item{formula}{in case of two sample z-test (i.e., \code{paired = FALSE}), a formula of the form \code{y ~ group} where \code{group} is a numeric variable, character variable or factor with two values or factor levels giving the corresponding groups.}
\item{data}{a matrix or data frame containing the variables in the formula \code{formula}.}
\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, list with the input specified in \code{x}
(\code{data}), specification of function arguments (\code{args}), and result table (\code{result}).
}
\description{
This function performs one-sample, two-sample, and paired-sample z-tests.
}
\details{
Cohen's d reported when argument \code{effsize = TRUE} is based on the population standard deviation
specified in \code{sigma} or the square root of the population variance specified in \code{sigma2}.
In a one-sample and paired-sample design, Cohen's d is the mean of the difference scores divided
by the population standard deviation of the difference scores (i.e., equivalent to Cohen's \eqn{d_z}
according to Lakens, 2013). In a two-sample design, Cohen's d is the difference between means of the
two groups of observations divided by either the population standard deviation when assuming and
specifying equal standard deviations or the unweighted pooled population standard deviation
when assuming and specifying unequal standard deviations.
}
\examples{
dat1 <- data.frame(group = c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
                   x = c(3, 1, 4, 2, 5, 3, 2, 3, 6, 4, 3, NA))

#--------------------------------------
# One-Sample Design

# Two-sided one-sample z-test
# population mean = 3, population standard deviation = 1.2
test.z(dat1$x, sigma = 1.2, mu = 3)

# Two-sided one-sample z-test
# population mean = 3, population variance = 1.44
test.z(dat1$x, sigma2 = 1.44, mu = 3)

# One-sided one-sample z-test
# population mean = 3, population standard deviation = 1.2
test.z(dat1$x, sigma = 1.2, mu = 3, alternative = "greater")

# Two-sided one-sample z-test
# population mean = 3, population standard deviation = 1.2
# convert value 3 to NA
test.z(dat1$x, sigma = 1.2, mu = 3, as.na = 3)

# Two-sided one-sample z-test
# population mean = 3, population standard deviation = 1.2
# print Cohen's d
test.z(dat1$x, sigma = 1.2, mu = 3, effsize = TRUE)

# Two-sided one-sample z-test
# population mean = 3, population standard deviation = 1.2
# do not print hypotheses and descriptive statistics
test.z(dat1$x, sigma = 1.2, mu = 3, hypo = FALSE, descript = FALSE)

# Two-sided one-sample z-test
# population mean = 3, population standard deviation = 1.2
# print descriptive statistics with 3 digits and p-value with 5 digits
test.z(dat1$x, sigma = 1.2, mu = 3, digits = 3, p.digits = 5)

#--------------------------------------
# Two-Sample Design

# Two-sided two-sample z-test
# population standard deviation (SD) = 1.2, equal SD assumption
test.z(x ~ group, sigma = 1.2, data = dat1)

# Two-sided two-sample z-test
# population standard deviation (SD) = 1.2 and 1.5, unequal SD assumption
test.z(x ~ group, sigma = c(1.2, 1.5), data = dat1)

# Two-sided two-sample z-test
# population variance (Var) = 1.44 and 2.25, unequal Var assumption
test.z(x ~ group, sigma2 = c(1.44, 2.25), data = dat1)

# One-sided two-sample z-test
# population standard deviation (SD) = 1.2, equal SD assumption
test.z(x ~ group, sigma = 1.2, data = dat1, alternative = "greater")

# Two-sided two-sample z-test
# population standard deviation (SD) = 1.2, equal SD assumption
# print Cohen's d
test.z(x ~ group, sigma = 1.2, data = dat1, effsize = TRUE)

# Two-sided two-sample z-test
# population standard deviation (SD) = 1.2, equal SD assumption
# do not print hypotheses and descriptive statistics,
# print Cohen's d
test.z(x ~ group, sigma = 1.2, data = dat1, descript = FALSE, hypo = FALSE)

# Two-sided two-sample z-test
# population mean = 3, population standard deviation = 1.2
# print descriptive statistics with 3 digits and p-value with 5 digits
test.z(x ~ group, sigma = 1.2, data = dat1, digits = 3, p.digits = 5)

#-----------------

group1 <- c(3, 1, 4, 2, 5, 3, 6, 7)
group2 <- c(5, 2, 4, 3, 1)

# Two-sided two-sample z-test
# population standard deviation (SD) = 1.2, equal SD assumption
test.z(group1, group2, sigma = 1.2)

#--------------------------------------
# Paired-Sample Design

dat2 <- data.frame(pre = c(1, 3, 2, 5, 7),
                   post = c(2, 2, 1, 6, 8), stringsAsFactors = FALSE)

# Two-sided paired-sample z-test
# population standard deviation of difference score = 1.2
test.z(dat2$pre, dat2$post, sigma = 1.2, paired = TRUE)

# Two-sided paired-sample z-test
# population variance of difference score = 1.44
test.z(dat2$pre, dat2$post, sigma2 = 1.44, paired = TRUE)

# One-sided paired-sample z-test
# population standard deviation of difference score = 1.2
test.z(dat2$pre, dat2$post, sigma = 1.2, paired = TRUE,
       alternative = "greater")

# Two-sided paired-sample z-test
# population standard deviation of difference score = 1.2
# convert value 1 to NA
test.z(dat2$pre, dat2$post, sigma = 1.2, as.na = 1, paired = TRUE)

# Two-sided paired-sample z-test
# population standard deviation of difference score = 1.2
# print Cohen's d
test.z(dat2$pre, dat2$post, sigma = 1.2, paired = TRUE, effsize = TRUE)

# Two-sided paired-sample z-test
# population standard deviation of difference score = 1.2
# do not print hypotheses and descriptive statistics
test.z(dat2$pre, dat2$post, sigma = 1.2, mu = 3, paired = TRUE,
       hypo = FALSE, descript = FALSE)

# Two-sided paired-sample z-test
# population standard deviation of difference score = 1.2
# print descriptive statistics with 3 digits and p-value with 5 digits
test.z(dat2$pre, dat2$post, sigma = 1.2, paired = TRUE,
       digits = 3, p.digits = 5)
}
\references{
Lakens, D. (2013). Calculating and reporting effect sizes to facilitate cumulative science:
A practical primer for t-tests and ANOVAs. \emph{Frontiers in Psychology, 4}, 1-12.
https://doi.org/10.3389/fpsyg.2013.00863

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.
}
\seealso{
\code{\link{test.t}}, \code{\link{cohens.d}}, \code{\link{ci.mean.diff}}, \code{\link{ci.mean}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
